/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.Database;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.EmptyString;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.IString;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.ModificationLog;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.BaseField;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.IDestructableField;

public class FieldString
extends BaseField
implements IDestructableField {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private final ModificationLog.Tag putTag;
    private final ModificationLog.Tag destructTag;

    public FieldString(String structName, int fieldNumber) {
        this.putTag = ModificationLog.createTag("Writing field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.destructTag = ModificationLog.createTag("Destructing field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
    }

    public IString get(Nd nd, long address) {
        Database db = nd.getDB();
        long namerec = db.getRecPtr(address + (long)this.offset);
        if (namerec == 0L) {
            return EmptyString.create();
        }
        return db.getString(namerec);
    }

    public void put(Nd nd, long address, char[] newString) {
        Database db = nd.getDB();
        db.getLog().start(this.putTag);
        try {
            IString name;
            if (newString == null) {
                newString = EMPTY_CHAR_ARRAY;
            }
            if ((name = this.get(nd, address)).compare(newString, true) != 0) {
                name.delete();
                if (newString != null && newString.length > 0) {
                    db.putRecPtr(address + (long)this.offset, db.newString(newString).getRecord());
                } else {
                    db.putRecPtr(address + (long)this.offset, 0L);
                }
            }
        }
        finally {
            db.getLog().end(this.putTag);
        }
    }

    public void put(Nd nd, long address, String newString) {
        this.put(nd, address, newString.toCharArray());
    }

    @Override
    public void destruct(Nd nd, long address) {
        Database db = nd.getDB();
        db.getLog().start(this.destructTag);
        try {
            this.get(nd, address).delete();
            nd.getDB().putRecPtr(address + (long)this.offset, 0L);
        }
        finally {
            db.getLog().end(this.destructTag);
        }
    }

    @Override
    public int getRecordSize() {
        return 4;
    }
}

