/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathContainer;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.UserLibrary;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.UserLibraryClasspathContainer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class UserLibraryManager {
    private Map userLibraries;

    public UserLibraryManager() {
        this.initialize();
    }

    public synchronized UserLibrary getUserLibrary(String libName) {
        return (UserLibrary)this.userLibraries.get(libName);
    }

    private void initialize() {
        String[] propertyNames;
        this.userLibraries = new HashMap();
        IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
        try {
            propertyNames = instancePreferences.keys();
        }
        catch (BackingStoreException e) {
            Util.log(e, "Exception while initializing user libraries");
            return;
        }
        boolean preferencesNeedFlush = false;
        int i = 0;
        int length = propertyNames.length;
        while (i < length) {
            block9: {
                String propertyValue;
                String propertyName = propertyNames[i];
                if (propertyName.startsWith("io.spring.javaformat.eclipse.jdt.jdk8.core.userLibrary.") && (propertyValue = instancePreferences.get(propertyName, null)) != null) {
                    UserLibrary library;
                    String libName = propertyName.substring("io.spring.javaformat.eclipse.jdt.jdk8.core.userLibrary.".length());
                    StringReader reader = new StringReader(propertyValue);
                    try {
                        library = UserLibrary.createFromString(reader);
                    }
                    catch (ClasspathEntry.AssertionFailedException | IOException e) {
                        Util.log(e, "Exception while initializing user library " + libName);
                        instancePreferences.remove(propertyName);
                        preferencesNeedFlush = true;
                        break block9;
                    }
                    this.userLibraries.put(libName, library);
                }
            }
            ++i;
        }
        if (preferencesNeedFlush) {
            try {
                instancePreferences.flush();
            }
            catch (BackingStoreException e) {
                Util.log(e, "Exception while flusing instance preferences");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserLibrary(String libName, String encodedUserLibrary) {
        try {
            Object javaProject;
            IPath containerPath = new Path("io.spring.javaformat.eclipse.jdt.jdk8.USER_LIBRARY").append(libName);
            IJavaProject[] allJavaProjects = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            ArrayList<Object> affectedProjects = new ArrayList<Object>();
            int i = 0;
            while (i < allJavaProjects.length) {
                javaProject = allJavaProjects[i];
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                int j = 0;
                while (j < entries.length) {
                    IClasspathEntry entry = entries[j];
                    if (entry.getEntryKind() == 5 && containerPath.equals((Object)entry.getPath())) {
                        affectedProjects.add(javaProject);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            UserLibrary userLibrary = encodedUserLibrary == null ? null : UserLibrary.createFromString(new StringReader(encodedUserLibrary));
            javaProject = this;
            synchronized (javaProject) {
                if (userLibrary != null) {
                    this.userLibraries.put(libName, userLibrary);
                } else {
                    this.userLibraries.remove(libName);
                }
            }
            int length = affectedProjects.size();
            if (length == 0) {
                return;
            }
            IJavaProject[] projects = new IJavaProject[length];
            affectedProjects.toArray(projects);
            IClasspathContainer[] containers = new IClasspathContainer[length];
            if (userLibrary != null) {
                UserLibraryClasspathContainer container = new UserLibraryClasspathContainer(libName);
                int i2 = 0;
                while (i2 < length) {
                    containers[i2] = container;
                    ++i2;
                }
            }
            JavaCore.setClasspathContainer(containerPath, projects, containers, null);
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e), "Exception while setting user library '" + libName + "'.");
        }
        catch (ClasspathEntry.AssertionFailedException | IOException ase) {
            Util.log(ase, "Exception while decoding user library '" + libName + "'.");
        }
    }
}

