/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModulePathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.IJavaElementRequestor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ProjectEntry;
import java.util.HashMap;
import java.util.Map;

public class ModuleSourcePathManager {
    private Map<String, IModulePathEntry> knownModules = new HashMap<String, IModulePathEntry>(11);

    private IModulePathEntry getModuleRoot0(String name) {
        return this.knownModules.get(name);
    }

    public void addEntry(IModuleDescription module, JavaProject project) throws JavaModelException {
        String moduleName = new String(module.getElementName().toCharArray());
        IModulePathEntry entry = this.getModuleRoot0(moduleName);
        if (entry != null) {
            return;
        }
        this.knownModules.put(moduleName, new ProjectEntry(project));
    }

    public void removeEntry(JavaProject javaProject) {
        String key;
        Map.Entry entry = this.knownModules.entrySet().stream().filter(e -> ProjectEntry.representsProject((IModulePathEntry)e.getValue(), javaProject)).findFirst().orElse(null);
        String string = key = entry != null ? (String)entry.getKey() : null;
        if (key != null) {
            this.knownModules.remove(key);
        }
    }

    public void seekModule(char[] name, boolean prefixMatch, IJavaElementRequestor requestor) throws JavaModelException {
        if (name == null) {
            return;
        }
        IPrefixMatcherCharArray prefixMatcher = prefixMatch ? (CharOperation.equals(name, CharOperation.ALL_PREFIX) ? (x, y) -> true : CharOperation::prefixEquals) : CharOperation::equals;
        IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            IModuleDescription module;
            IJavaProject project = projects[i];
            if (project.getProject().isAccessible() && project instanceof JavaProject && (module = ((JavaProject)project).getModuleDescription()) != null && prefixMatcher.matches(name, module.getElementName().toCharArray())) {
                requestor.acceptModule(module);
            }
            ++i;
        }
    }

    static interface IPrefixMatcherCharArray {
        public boolean matches(char[] var1, char[] var2);
    }
}

