/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ISourceRange;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.AbstractModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryMember;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavadocContents;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ModularClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.SourceMapper;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.LRUCache;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class BinaryModule
extends BinaryMember
implements AbstractModule {
    private IBinaryModule info;

    public BinaryModule(JavaElement parent, String name) {
        super(parent, name);
    }

    public BinaryModule(JavaElement parent, IBinaryModule info) {
        super(parent, String.valueOf(info.name()));
        this.info = info;
    }

    @Override
    public IModule getModuleInfo() throws JavaModelException {
        if (this.info == null) {
            ModularClassFile classFile = (ModularClassFile)this.parent;
            this.info = classFile.getBinaryModuleInfo();
        }
        return this.info;
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryModule moduleInfo = (IBinaryModule)this.getModuleInfo();
        IBinaryAnnotation[] binaryAnnotations = moduleInfo.getAnnotations();
        long tagBits = moduleInfo.getTagBits() & 0xFFFFBFFFFFFFFFFFL;
        return this.getAnnotations(binaryAnnotations, tagBits);
    }

    @Override
    public IJavaElement[] getChildren() throws JavaModelException {
        return NO_ELEMENTS;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public int getFlags() throws JavaModelException {
        if (this.getModuleInfo().isOpen()) {
            return 32;
        }
        return 0;
    }

    @Override
    public char getHandleMementoDelimiter() {
        return '`';
    }

    @Override
    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            ((ModularClassFile)this.getClassFile()).getBuffer();
            return mapper.getSourceRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        JavadocContents javadocContents = this.getJavadocContents(monitor);
        if (javadocContents == null) {
            return null;
        }
        return javadocContents.getModuleDoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavadocContents getJavadocContents(IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager.PerProjectInfo projectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.getJavaProject().getProject());
        JavadocContents cachedJavadoc = null;
        LRUCache<IJavaElement, Object> lRUCache = projectInfo.javadocCache;
        synchronized (lRUCache) {
            cachedJavadoc = (JavadocContents)projectInfo.javadocCache.get(this);
        }
        if (cachedJavadoc != null && cachedJavadoc != BinaryType.EMPTY_JAVADOC) {
            return cachedJavadoc;
        }
        URL baseLocation = this.getJavadocBaseLocation();
        if (baseLocation == null) {
            return null;
        }
        StringBuffer pathBuffer = new StringBuffer(baseLocation.toExternalForm());
        if (pathBuffer.charAt(pathBuffer.length() - 1) != '/') {
            pathBuffer.append('/');
        }
        pathBuffer.append(this.getElementName()).append("-summary.html");
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String contents = this.getURLContents(baseLocation, String.valueOf(pathBuffer));
        JavadocContents javadocContents = new JavadocContents(contents);
        LRUCache<IJavaElement, Object> lRUCache2 = projectInfo.javadocCache;
        synchronized (lRUCache2) {
            projectInfo.javadocCache.put(this, javadocContents);
        }
        return javadocContents;
    }
}

