/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.spring.initializr.metadata.DefaultMetadataElement;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.web.support.InitializrMetadataUpdateStrategy;
import io.spring.initializr.web.support.SpringBootMetadataReader;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SpringIoInitializrMetadataUpdateStrategy
implements InitializrMetadataUpdateStrategy {
    private static final Log logger = LogFactory.getLog(SpringIoInitializrMetadataUpdateStrategy.class);
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    public SpringIoInitializrMetadataUpdateStrategy(RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    @Override
    public InitializrMetadata update(InitializrMetadata current) {
        String url = current.getConfiguration().getEnv().getSpringBootMetadataUrl();
        List<DefaultMetadataElement> bootVersions = this.fetchSpringBootVersions(url);
        if (bootVersions != null && !bootVersions.isEmpty()) {
            if (bootVersions.stream().noneMatch(DefaultMetadataElement::isDefault)) {
                bootVersions.get(0).setDefault(true);
            }
            current.updateSpringBootVersions(bootVersions);
        }
        return current;
    }

    protected List<DefaultMetadataElement> fetchSpringBootVersions(String url) {
        if (StringUtils.hasText((String)url)) {
            try {
                logger.info((Object)("Fetching Spring Boot metadata from " + url));
                return new SpringBootMetadataReader(this.objectMapper, this.restTemplate, url).getBootVersions();
            }
            catch (Exception ex) {
                logger.warn((Object)"Failed to fetch Spring Boot metadata", (Throwable)ex);
            }
        }
        return null;
    }
}

