/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.spring.initializr.metadata.InitializrConfiguration;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.InitializrMetadataCustomizer;
import io.spring.initializr.metadata.InitializrProperties;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public final class InitializrMetadataBuilder {
    private final List<InitializrMetadataCustomizer> customizers = new ArrayList<InitializrMetadataCustomizer>();
    private final InitializrConfiguration configuration;

    private InitializrMetadataBuilder(InitializrConfiguration configuration) {
        this.configuration = configuration;
    }

    public InitializrMetadataBuilder withInitializrProperties(InitializrProperties properties) {
        return this.withInitializrProperties(properties, false);
    }

    public InitializrMetadataBuilder withInitializrProperties(InitializrProperties properties, boolean mergeConfiguration) {
        if (mergeConfiguration) {
            this.configuration.merge(properties);
        }
        return this.withCustomizer(new InitializerPropertiesCustomizer(properties));
    }

    public InitializrMetadataBuilder withInitializrMetadata(Resource resource) {
        return this.withCustomizer(new ResourceInitializrMetadataCustomizer(resource));
    }

    public InitializrMetadataBuilder withCustomizer(InitializrMetadataCustomizer customizer) {
        this.customizers.add(customizer);
        return this;
    }

    public InitializrMetadata build() {
        InitializrConfiguration config = this.configuration != null ? this.configuration : new InitializrConfiguration();
        InitializrMetadata metadata = this.createInstance(config);
        for (InitializrMetadataCustomizer customizer : this.customizers) {
            customizer.customize(metadata);
        }
        this.applyDefaults(metadata);
        metadata.validate();
        return metadata;
    }

    protected InitializrMetadata createInstance(InitializrConfiguration configuration) {
        return new InitializrMetadata(configuration);
    }

    protected void applyDefaults(InitializrMetadata metadata) {
        if (!StringUtils.hasText((String)metadata.getName().getContent())) {
            metadata.getName().setContent("demo");
        }
        if (!StringUtils.hasText((String)metadata.getDescription().getContent())) {
            metadata.getDescription().setContent("Demo project for Spring Boot");
        }
        if (!StringUtils.hasText((String)metadata.getGroupId().getContent())) {
            metadata.getGroupId().setContent("com.example");
        }
        if (!StringUtils.hasText((String)metadata.getVersion().getContent())) {
            metadata.getVersion().setContent("0.0.1-SNAPSHOT");
        }
    }

    public static InitializrMetadataBuilder fromInitializrProperties(InitializrProperties configuration) {
        return new InitializrMetadataBuilder(configuration).withInitializrProperties(configuration);
    }

    public static InitializrMetadataBuilder create() {
        return new InitializrMetadataBuilder(new InitializrConfiguration());
    }

    private static class InitializerPropertiesCustomizer
    implements InitializrMetadataCustomizer {
        private final InitializrProperties properties;

        InitializerPropertiesCustomizer(InitializrProperties properties) {
            this.properties = properties;
        }

        @Override
        public void customize(InitializrMetadata metadata) {
            metadata.getDependencies().merge(this.properties.getDependencies());
            metadata.getTypes().merge(this.properties.getTypes());
            metadata.getBootVersions().merge(this.properties.getBootVersions());
            metadata.getPackagings().merge(this.properties.getPackagings());
            metadata.getJavaVersions().merge(this.properties.getJavaVersions());
            metadata.getLanguages().merge(this.properties.getLanguages());
            this.properties.getGroupId().apply(metadata.getGroupId());
            this.properties.getArtifactId().apply(metadata.getArtifactId());
            this.properties.getVersion().apply(metadata.getVersion());
            this.properties.getName().apply(metadata.getName());
            this.properties.getDescription().apply(metadata.getDescription());
            this.properties.getPackageName().apply(metadata.getPackageName());
        }
    }

    private static class ResourceInitializrMetadataCustomizer
    implements InitializrMetadataCustomizer {
        private static final Log logger = LogFactory.getLog(ResourceInitializrMetadataCustomizer.class);
        private static final Charset UTF_8 = StandardCharsets.UTF_8;
        private final Resource resource;

        ResourceInitializrMetadataCustomizer(Resource resource) {
            this.resource = resource;
        }

        @Override
        public void customize(InitializrMetadata metadata) {
            logger.info((Object)("Loading initializr metadata from " + this.resource));
            try (InputStream in = this.resource.getInputStream();){
                String content = StreamUtils.copyToString((InputStream)in, (Charset)UTF_8);
                ObjectMapper objectMapper = new ObjectMapper();
                InitializrMetadata anotherMetadata = (InitializrMetadata)objectMapper.readValue(content, InitializrMetadata.class);
                metadata.merge(anotherMetadata);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot merge", ex);
            }
        }
    }
}

