/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.scm.git;

import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.project.ProjectGenerationConfiguration;
import io.spring.initializr.generator.spring.scm.git.GitIgnore;
import io.spring.initializr.generator.spring.scm.git.GitIgnoreContributor;
import io.spring.initializr.generator.spring.scm.git.GitIgnoreCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;

@ProjectGenerationConfiguration
public class GitProjectGenerationConfiguration {
    @Bean
    public GitIgnoreContributor gitIgnoreContributor(GitIgnore gitIgnore) {
        return new GitIgnoreContributor(gitIgnore);
    }

    @Bean
    public GitIgnore gitIgnore(ObjectProvider<GitIgnoreCustomizer> gitIgnoreCustomizers) {
        GitIgnore gitIgnore = this.createGitIgnore();
        gitIgnoreCustomizers.orderedStream().forEach(customizer -> customizer.customize(gitIgnore));
        return gitIgnore;
    }

    @Bean
    @ConditionalOnBuildSystem(value="maven")
    public GitIgnoreCustomizer mavenGitIgnoreCustomizer() {
        return gitIgnore -> {
            gitIgnore.getGeneral().add("target/", "!.mvn/wrapper/maven-wrapper.jar", "!**/src/main/**/target/", "!**/src/test/**/target/");
            gitIgnore.getNetBeans().add("build/", "!**/src/main/**/build/", "!**/src/test/**/build/");
        };
    }

    @Bean
    @ConditionalOnBuildSystem(value="gradle")
    public GitIgnoreCustomizer gradleGitIgnoreCustomizer() {
        return gitIgnore -> {
            gitIgnore.getGeneral().add(".gradle", "build/", "!gradle/wrapper/gradle-wrapper.jar", "!**/src/main/**/build/", "!**/src/test/**/build/");
            gitIgnore.getIntellijIdea().add("out/", "!**/src/main/**/out/", "!**/src/test/**/out/");
            gitIgnore.getSts().add("bin/", "!**/src/main/**/bin/", "!**/src/test/**/bin/");
        };
    }

    private GitIgnore createGitIgnore() {
        GitIgnore gitIgnore = new GitIgnore();
        gitIgnore.getSts().add(".apt_generated", ".classpath", ".factorypath", ".project", ".settings", ".springBeans", ".sts4-cache");
        gitIgnore.getIntellijIdea().add(".idea", "*.iws", "*.iml", "*.ipr");
        gitIgnore.getNetBeans().add("/nbproject/private/", "/nbbuild/", "/dist/", "/nbdist/", "/.nb-gradle/");
        gitIgnore.getVscode().add(".vscode/");
        return gitIgnore;
    }
}

