/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.io;

import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.SimpleIndentStrategy;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public final class IndentingWriterFactory {
    private final Function<Integer, String> defaultIndentingStrategy;
    private final Map<String, Function<Integer, String>> indentingStrategies;

    private IndentingWriterFactory(Builder builder) {
        this.defaultIndentingStrategy = builder.defaultIndentingStrategy;
        this.indentingStrategies = new HashMap<String, Function<Integer, String>>(builder.indentingStrategies);
    }

    public IndentingWriter createIndentingWriter(String contentId, Writer out) {
        Function<Integer, String> indentingStrategy = this.indentingStrategies.getOrDefault(contentId, this.defaultIndentingStrategy);
        return new IndentingWriter(out, indentingStrategy);
    }

    public static IndentingWriterFactory withDefaultSettings() {
        return IndentingWriterFactory.create(new SimpleIndentStrategy("    "));
    }

    public static IndentingWriterFactory create(Function<Integer, String> defaultIndentingStrategy) {
        return new IndentingWriterFactory(new Builder(defaultIndentingStrategy));
    }

    public static IndentingWriterFactory create(Function<Integer, String> defaultIndentingStrategy, Consumer<Builder> factory) {
        Builder factoryBuilder = new Builder(defaultIndentingStrategy);
        factory.accept(factoryBuilder);
        return new IndentingWriterFactory(factoryBuilder);
    }

    public static final class Builder {
        private final Function<Integer, String> defaultIndentingStrategy;
        private final Map<String, Function<Integer, String>> indentingStrategies = new HashMap<String, Function<Integer, String>>();

        private Builder(Function<Integer, String> defaultIndentingStrategy) {
            this.defaultIndentingStrategy = defaultIndentingStrategy;
        }

        public Builder indentingStrategy(String contentId, Function<Integer, String> indentingStrategy) {
            this.indentingStrategies.put(contentId, indentingStrategy);
            return this;
        }
    }
}

