/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import java.util.Objects;

public class Attribute {
    private final String name;
    private final String value;
    private final Type type;

    protected Attribute(String name, String value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public static Attribute set(String name, String value) {
        return new Attribute(name, value, Type.SET);
    }

    public static Attribute append(String name, String value) {
        return new Attribute(name, value, Type.APPEND);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name) && Objects.equals(this.value, attribute.value) && this.type == attribute.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.type});
    }

    public String toString() {
        return this.name + (this.type == Type.SET ? " = " : " += ") + this.value;
    }

    public static enum Type {
        SET,
        APPEND;

    }
}

