/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import io.spring.initializr.generator.buildsystem.Dependency;
import java.util.Comparator;

public class DependencyComparator
implements Comparator<Dependency> {
    public static final DependencyComparator INSTANCE = new DependencyComparator();

    @Override
    public int compare(Dependency o1, Dependency o2) {
        if (this.isSpringBootDependency(o1) && this.isSpringBootDependency(o2)) {
            return o1.getArtifactId().compareTo(o2.getArtifactId());
        }
        if (this.isSpringBootDependency(o1)) {
            return -1;
        }
        if (this.isSpringBootDependency(o2)) {
            return 1;
        }
        int group = o1.getGroupId().compareTo(o2.getGroupId());
        if (group != 0) {
            return group;
        }
        return o1.getArtifactId().compareTo(o2.getArtifactId());
    }

    private boolean isSpringBootDependency(Dependency dependency) {
        return dependency.getGroupId().startsWith("org.springframework.boot");
    }
}

