/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.core.protocol.RpcMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MessageFuture {
    private RpcMessage requestMessage;
    private long timeout;
    private long start = System.currentTimeMillis();
    private static final Object NULL = new Object();
    private transient CompletableFuture origin = new CompletableFuture();

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.start > this.timeout;
    }

    public Object get(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Object result = null;
        try {
            result = this.origin.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new ShouldNeverHappenException("Should not get results in a multi-threaded environment", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new TimeoutException("cost " + (System.currentTimeMillis() - this.start) + " ms");
        }
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        if (result instanceof Throwable) {
            throw new RuntimeException(result);
        }
        return result;
    }

    public void setResultMessage(Object obj) {
        this.origin.complete(obj);
    }

    public RpcMessage getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(RpcMessage requestMessage) {
        this.requestMessage = requestMessage;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

