/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.store.utils;

import io.seata.common.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

    public static String beanToString(Object o) {
        if (o == null) {
            return null;
        }
        Field[] fields = o.getClass().getDeclaredFields();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (Field field : fields) {
            Object val = null;
            try {
                val = ReflectionUtil.getFieldValue(o, field.getName());
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            if (val == null) continue;
            buffer.append(field.getName()).append("=").append(val).append(", ");
        }
        if (buffer.length() > 2) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

