/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.store.db;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.core.context.RootContext;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.GlobalStatus;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.sequence.SeqGenerator;
import io.seata.saga.engine.serializer.Serializer;
import io.seata.saga.engine.serializer.impl.ExceptionSerializer;
import io.seata.saga.engine.serializer.impl.ParamsFastjsonSerializer;
import io.seata.saga.engine.store.StateLogStore;
import io.seata.saga.engine.store.db.AbstractStore;
import io.seata.saga.engine.store.db.StateLogStoreSqls;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.impl.StateInstanceImpl;
import io.seata.saga.statelang.domain.impl.StateMachineInstanceImpl;
import io.seata.saga.tm.SagaTransactionalTemplate;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.TransactionInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DbAndReportTcStateLogStore
extends AbstractStore
implements StateLogStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAndReportTcStateLogStore.class);
    private SagaTransactionalTemplate sagaTransactionalTemplate;
    private Serializer<Object, String> paramsSerializer = new ParamsFastjsonSerializer();
    private Serializer<Exception, byte[]> exceptionSerializer = new ExceptionSerializer();
    private StateLogStoreSqls stateLogStoreSqls;
    private String defaultTenantId;
    private SeqGenerator seqGenerator;
    private static final StateMachineInstanceToStatementForInsert STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_INSERT = new StateMachineInstanceToStatementForInsert();
    private static final StateMachineInstanceToStatementForUpdate STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_UPDATE = new StateMachineInstanceToStatementForUpdate();
    private static final ResultSetToStateMachineInstance RESULT_SET_TO_STATE_MACHINE_INSTANCE = new ResultSetToStateMachineInstance();
    private static final StateInstanceToStatementForInsert STATE_INSTANCE_TO_STATEMENT_FOR_INSERT = new StateInstanceToStatementForInsert();
    private static final StateInstanceToStatementForUpdate STATE_INSTANCE_TO_STATEMENT_FOR_UPDATE = new StateInstanceToStatementForUpdate();
    private static final ResultSetToStateInstance RESULT_SET_TO_STATE_INSTANCE = new ResultSetToStateInstance();

    @Override
    public void recordStateMachineStarted(StateMachineInstance machineInstance, ProcessContext context) {
        if (machineInstance != null) {
            this.beginTransaction(machineInstance, context);
            if (StringUtils.isEmpty((Object)machineInstance.getId()) && this.seqGenerator != null) {
                machineInstance.setId(this.seqGenerator.generate("STATE_MACHINE_INST"));
            }
            machineInstance.setSerializedStartParams(this.paramsSerializer.serialize(machineInstance.getStartParams()));
            this.executeUpdate(this.stateLogStoreSqls.getRecordStateMachineStartedSql(this.dbType), STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_INSERT, machineInstance);
        }
    }

    private void beginTransaction(StateMachineInstance machineInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            TransactionInfo transactionInfo = new TransactionInfo();
            transactionInfo.setTimeOut(this.sagaTransactionalTemplate.getTimeout());
            transactionInfo.setName(machineInstance.getStateMachine().getName());
            try {
                GlobalTransaction globalTransaction = this.sagaTransactionalTemplate.beginTransaction(transactionInfo);
                machineInstance.setId(globalTransaction.getXid());
                context.setVariable("_global_transaction_", globalTransaction);
                Map<String, Object> machineContext = machineInstance.getContext();
                if (machineContext != null) {
                    machineContext.put("_global_transaction_", globalTransaction);
                }
                context.setVariable("_root_context_holder_", RootContext.entries());
            }
            catch (TransactionalExecutor.ExecutionException e) {
                String xid = null;
                if (e.getTransaction() != null) {
                    xid = e.getTransaction().getXid();
                }
                throw new EngineExecutionException(e, (Object)((Object)e.getCode()) + ", TransName:" + transactionInfo.getName() + ", XID: " + xid + ", Reason: " + e.getMessage(), FrameworkErrorCode.TransactionManagerError);
            }
        }
    }

    @Override
    public void recordStateMachineFinished(StateMachineInstance machineInstance, ProcessContext context) {
        if (machineInstance != null) {
            Map<String, Object> endParams = machineInstance.getEndParams();
            if (endParams != null) {
                endParams.remove("_global_transaction_");
            }
            machineInstance.setSerializedEndParams(this.paramsSerializer.serialize(machineInstance.getEndParams()));
            machineInstance.setSerializedException(this.exceptionSerializer.serialize(machineInstance.getException()));
            this.executeUpdate(this.stateLogStoreSqls.getRecordStateMachineFinishedSql(this.dbType), STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_UPDATE, machineInstance);
            this.reportTransactionFinished(machineInstance, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTransactionFinished(StateMachineInstance machineInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            try {
                GlobalTransaction globalTransaction = (GlobalTransaction)context.getVariable("_global_transaction_");
                if (globalTransaction == null) {
                    globalTransaction = GlobalTransactionContext.reload(machineInstance.getId());
                }
                if (globalTransaction == null) {
                    throw new EngineExecutionException("Global transaction is not exists", FrameworkErrorCode.ObjectNotExists);
                }
                GlobalStatus globalStatus = ExecutionStatus.SU.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null ? GlobalStatus.Committed : (ExecutionStatus.SU.equals((Object)machineInstance.getCompensationStatus()) ? GlobalStatus.Rollbacked : (ExecutionStatus.FA.equals((Object)machineInstance.getCompensationStatus()) || ExecutionStatus.UN.equals((Object)machineInstance.getCompensationStatus()) ? GlobalStatus.RollbackRetrying : (ExecutionStatus.FA.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null ? GlobalStatus.Finished : (ExecutionStatus.UN.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null ? GlobalStatus.CommitRetrying : GlobalStatus.UnKnown))));
                this.sagaTransactionalTemplate.reportTransaction(globalTransaction, globalStatus);
            }
            catch (TransactionalExecutor.ExecutionException e) {
                LOGGER.error("Report transaction finish to server error: ", (Object)((Object)((Object)e.getCode()) + ", StateMachine:" + machineInstance.getStateMachine().getName() + ", XID: " + machineInstance.getId() + ", Reason: " + e.getMessage()), (Object)e);
            }
            catch (TransactionException e) {
                LOGGER.error("Report transaction finish to server error: " + (Object)((Object)e.getCode()) + ", StateMachine:" + machineInstance.getStateMachine().getName() + ", XID: " + machineInstance.getId() + ", Reason: " + e.getMessage(), (Throwable)e);
            }
            finally {
                Map rootContextEntries = (Map)context.getVariable("_root_context_holder_");
                if (rootContextEntries != null) {
                    rootContextEntries.clear();
                }
                this.sagaTransactionalTemplate.triggerAfterCompletion();
                this.sagaTransactionalTemplate.cleanUp();
            }
        }
    }

    @Override
    public void recordStateMachineRestarted(StateMachineInstance machineInstance, ProcessContext context) {
        if (machineInstance != null) {
            this.executeUpdate(this.stateLogStoreSqls.getUpdateStateMachineRunningStatusSql(this.dbType), machineInstance.isRunning(), machineInstance.getId());
            this.reportTransactionRestarted(machineInstance, context);
        }
    }

    private void reportTransactionRestarted(StateMachineInstance machineInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            GlobalStatus globalStatus = "compensate".equals(context.getVariable("_operation_name_")) ? GlobalStatus.Rollbacking : GlobalStatus.Committing;
            try {
                GlobalTransaction globalTransaction = (GlobalTransaction)context.getVariable("_global_transaction_");
                if (globalTransaction == null) {
                    globalTransaction = GlobalTransactionContext.reload(machineInstance.getId());
                }
                if (globalTransaction == null) {
                    throw new EngineExecutionException("Global transaction is not exists", FrameworkErrorCode.ObjectNotExists);
                }
                this.sagaTransactionalTemplate.reportTransaction(globalTransaction, globalStatus);
            }
            catch (TransactionalExecutor.ExecutionException e) {
                LOGGER.error("Report transaction status to server error: " + (Object)((Object)e.getCode()) + ", StateMachine:" + machineInstance.getStateMachine().getName() + ", XID: " + machineInstance.getId() + ", globalStatus:" + (Object)((Object)globalStatus) + ", Reason: " + e.getMessage(), (Throwable)e);
            }
            catch (TransactionException e) {
                LOGGER.error("Report transaction status to server error: " + (Object)((Object)e.getCode()) + ", StateMachine:" + machineInstance.getStateMachine().getName() + ", XID: " + machineInstance.getId() + ", globalStatus:" + (Object)((Object)globalStatus) + ", Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void recordStateStarted(StateInstance stateInstance, ProcessContext context) {
        if (stateInstance != null) {
            this.branchRegister(stateInstance, context);
            if (StringUtils.isEmpty((Object)stateInstance.getId()) && this.seqGenerator != null) {
                stateInstance.setId(this.seqGenerator.generate("STATE_INST"));
            }
            stateInstance.setSerializedInputParams(this.paramsSerializer.serialize(stateInstance.getInputParams()));
            this.executeUpdate(this.stateLogStoreSqls.getRecordStateStartedSql(this.dbType), STATE_INSTANCE_TO_STATEMENT_FOR_INSERT, stateInstance);
        }
    }

    private void branchRegister(StateInstance stateInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            try {
                GlobalTransaction globalTransaction = (GlobalTransaction)context.getVariable("_global_transaction_");
                if (globalTransaction == null) {
                    globalTransaction = GlobalTransactionContext.reload(stateInstance.getStateMachineInstance().getId());
                }
                if (globalTransaction == null) {
                    throw new EngineExecutionException("Global transaction is not exists", FrameworkErrorCode.ObjectNotExists);
                }
                String resourceId = stateInstance.getStateMachineInstance().getStateMachine().getName() + "#" + stateInstance.getName();
                long branchId = this.sagaTransactionalTemplate.branchRegister(resourceId, null, globalTransaction.getXid(), null, null);
                stateInstance.setId(String.valueOf(branchId));
            }
            catch (TransactionException e) {
                throw new EngineExecutionException(e, "Branch transaction error: " + (Object)((Object)e.getCode()) + ", StateMachine:" + stateInstance.getStateMachineInstance().getStateMachine().getName() + ", XID: " + stateInstance.getStateMachineInstance().getId() + ", State:" + stateInstance.getName() + ", stateId: " + stateInstance.getId() + ", Reason: " + e.getMessage(), FrameworkErrorCode.TransactionManagerError);
            }
        }
    }

    @Override
    public void recordStateFinished(StateInstance stateInstance, ProcessContext context) {
        if (stateInstance != null) {
            stateInstance.setSerializedOutputParams(this.paramsSerializer.serialize(stateInstance.getOutputParams()));
            stateInstance.setSerializedException(this.exceptionSerializer.serialize(stateInstance.getException()));
            this.executeUpdate(this.stateLogStoreSqls.getRecordStateFinishedSql(this.dbType), STATE_INSTANCE_TO_STATEMENT_FOR_UPDATE, stateInstance);
            this.branchReport(stateInstance, context);
        }
    }

    private void branchReport(StateInstance stateInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            BranchStatus branchStatus = null;
            try {
                GlobalTransaction globalTransaction = (GlobalTransaction)context.getVariable("_global_transaction_");
                if (globalTransaction == null) {
                    globalTransaction = GlobalTransactionContext.reload(stateInstance.getStateMachineInstance().getId());
                }
                if (globalTransaction == null) {
                    throw new EngineExecutionException("Global transaction is not exists", FrameworkErrorCode.ObjectNotExists);
                }
                branchStatus = ExecutionStatus.SU.equals((Object)stateInstance.getStatus()) && stateInstance.getCompensationStatus() == null ? BranchStatus.PhaseTwo_Committed : (ExecutionStatus.SU.equals((Object)stateInstance.getCompensationStatus()) ? BranchStatus.PhaseTwo_Rollbacked : (ExecutionStatus.FA.equals((Object)stateInstance.getCompensationStatus()) || ExecutionStatus.UN.equals((Object)stateInstance.getCompensationStatus()) ? BranchStatus.PhaseTwo_RollbackFailed_Retryable : ((ExecutionStatus.FA.equals((Object)stateInstance.getStatus()) || ExecutionStatus.UN.equals((Object)stateInstance.getStatus())) && stateInstance.getCompensationStatus() == null ? BranchStatus.PhaseOne_Failed : BranchStatus.Unknown)));
                this.sagaTransactionalTemplate.branchReport(globalTransaction.getXid(), Long.parseLong(stateInstance.getId()), branchStatus, null);
            }
            catch (TransactionException e) {
                LOGGER.error("Report branch status to server error: " + (Object)((Object)e.getCode()) + ", StateMachine:" + stateInstance.getStateMachineInstance().getStateMachine().getName() + ", StateName:" + stateInstance.getName() + ", XID: " + stateInstance.getStateMachineInstance().getId() + ", branchId: " + stateInstance.getId() + ", branchStatus:" + (Object)((Object)branchStatus) + ", Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public StateMachineInstance getStateMachineInstance(String stateMachineInstanceId) {
        StateMachineInstance stateMachineInstance = this.selectOne(this.stateLogStoreSqls.getGetStateMachineInstanceByIdSql(this.dbType), RESULT_SET_TO_STATE_MACHINE_INSTANCE, stateMachineInstanceId);
        if (stateMachineInstance == null) {
            return null;
        }
        List<StateInstance> stateInstanceList = this.queryStateInstanceListByMachineInstanceId(stateMachineInstanceId);
        for (StateInstance stateInstance : stateInstanceList) {
            stateMachineInstance.putStateInstance(stateInstance.getId(), stateInstance);
        }
        this.deserializeParamsAndException(stateMachineInstance);
        return stateMachineInstance;
    }

    @Override
    public StateMachineInstance getStateMachineInstanceByBusinessKey(String businessKey, String tenantId) {
        StateMachineInstance stateMachineInstance;
        if (StringUtils.isEmpty((Object)tenantId)) {
            tenantId = this.defaultTenantId;
        }
        if ((stateMachineInstance = this.selectOne(this.stateLogStoreSqls.getGetStateMachineInstanceByBusinessKeySql(this.dbType), RESULT_SET_TO_STATE_MACHINE_INSTANCE, businessKey, tenantId)) == null) {
            return null;
        }
        List<StateInstance> stateInstanceList = this.queryStateInstanceListByMachineInstanceId(stateMachineInstance.getId());
        for (StateInstance stateInstance : stateInstanceList) {
            stateMachineInstance.putStateInstance(stateInstance.getId(), stateInstance);
        }
        this.deserializeParamsAndException(stateMachineInstance);
        return stateMachineInstance;
    }

    private void deserializeParamsAndException(StateMachineInstance stateMachineInstance) {
        String serializedEndParams;
        String serializedStartParams;
        byte[] serializedException = (byte[])stateMachineInstance.getSerializedException();
        if (serializedException != null) {
            stateMachineInstance.setException(this.exceptionSerializer.deserialize(serializedException));
        }
        if (StringUtils.hasLength((String)(serializedStartParams = (String)stateMachineInstance.getSerializedStartParams()))) {
            stateMachineInstance.setStartParams((Map)this.paramsSerializer.deserialize(serializedStartParams));
        }
        if (StringUtils.hasLength((String)(serializedEndParams = (String)stateMachineInstance.getSerializedEndParams()))) {
            stateMachineInstance.setEndParams((Map)this.paramsSerializer.deserialize(serializedEndParams));
        }
    }

    @Override
    public List<StateMachineInstance> queryStateMachineInstanceByParentId(String parentId) {
        return this.selectList(this.stateLogStoreSqls.getQueryStateMachineInstancesByParentIdSql(this.dbType), RESULT_SET_TO_STATE_MACHINE_INSTANCE, parentId);
    }

    @Override
    public StateInstance getStateInstance(String stateInstanceId, String machineInstId) {
        StateInstance stateInstance = this.selectOne(this.stateLogStoreSqls.getGetStateInstanceByIdAndMachineInstanceIdSql(this.dbType), RESULT_SET_TO_STATE_INSTANCE, machineInstId, stateInstanceId);
        this.deserializeParamsAndException(stateInstance);
        return stateInstance;
    }

    private void deserializeParamsAndException(StateInstance stateInstance) {
        if (stateInstance != null) {
            byte[] serializedException;
            String outputParams;
            String inputParams = (String)stateInstance.getSerializedInputParams();
            if (StringUtils.hasLength((String)inputParams)) {
                stateInstance.setInputParams(this.paramsSerializer.deserialize(inputParams));
            }
            if (StringUtils.hasLength((String)(outputParams = (String)stateInstance.getSerializedOutputParams()))) {
                stateInstance.setOutputParams(this.paramsSerializer.deserialize(outputParams));
            }
            if ((serializedException = (byte[])stateInstance.getSerializedException()) != null) {
                stateInstance.setException(this.exceptionSerializer.deserialize(serializedException));
            }
        }
    }

    @Override
    public List<StateInstance> queryStateInstanceListByMachineInstanceId(String stateMachineInstanceId) {
        List<StateInstance> stateInstanceList = this.selectList(this.stateLogStoreSqls.getQueryStateInstancesByMachineInstanceIdSql(this.dbType), RESULT_SET_TO_STATE_INSTANCE, stateMachineInstanceId);
        if (stateInstanceList == null || stateInstanceList.size() == 0) {
            return stateInstanceList;
        }
        StateInstance lastStateInstance = stateInstanceList.get(stateInstanceList.size() - 1);
        if (lastStateInstance.getGmtEnd() == null) {
            lastStateInstance.setStatus(ExecutionStatus.RU);
        }
        HashMap<String, StateInstance> originStateMap = new HashMap<String, StateInstance>();
        HashMap<String, StateInstance> compensatedStateMap = new HashMap<String, StateInstance>();
        HashMap<String, StateInstance> retriedStateMap = new HashMap<String, StateInstance>();
        for (int i = 0; i < stateInstanceList.size(); ++i) {
            StateInstance tempStateInstance = stateInstanceList.get(i);
            this.deserializeParamsAndException(tempStateInstance);
            if (StringUtils.hasText((String)tempStateInstance.getStateIdCompensatedFor())) {
                this.putLastStateToMap(compensatedStateMap, tempStateInstance, tempStateInstance.getStateIdCompensatedFor());
                continue;
            }
            if (StringUtils.hasText((String)tempStateInstance.getStateIdRetriedFor())) {
                this.putLastStateToMap(retriedStateMap, tempStateInstance, tempStateInstance.getStateIdRetriedFor());
            }
            originStateMap.put(tempStateInstance.getId(), tempStateInstance);
        }
        if (compensatedStateMap.size() != 0) {
            for (StateInstance origState : originStateMap.values()) {
                origState.setCompensationState((StateInstance)compensatedStateMap.get(origState.getId()));
            }
        }
        if (retriedStateMap.size() != 0) {
            for (StateInstance origState : originStateMap.values()) {
                if (!retriedStateMap.containsKey(origState.getId())) continue;
                origState.setIgnoreStatus(true);
            }
        }
        return stateInstanceList;
    }

    private void putLastStateToMap(Map<String, StateInstance> resultMap, StateInstance newState, String key) {
        if (!resultMap.containsKey(key)) {
            resultMap.put(key, newState);
        } else if (newState.getGmtEnd().after(resultMap.get(key).getGmtEnd())) {
            StateInstance oldState = resultMap.remove(key);
            oldState.setIgnoreStatus(true);
            resultMap.put(key, newState);
        } else {
            newState.setIgnoreStatus(true);
        }
    }

    public void setExceptionSerializer(Serializer<Exception, byte[]> exceptionSerializer) {
        this.exceptionSerializer = exceptionSerializer;
    }

    public SagaTransactionalTemplate getSagaTransactionalTemplate() {
        return this.sagaTransactionalTemplate;
    }

    public void setSagaTransactionalTemplate(SagaTransactionalTemplate sagaTransactionalTemplate) {
        this.sagaTransactionalTemplate = sagaTransactionalTemplate;
    }

    public Serializer<Object, String> getParamsSerializer() {
        return this.paramsSerializer;
    }

    public void setParamsSerializer(Serializer<Object, String> paramsSerializer) {
        this.paramsSerializer = paramsSerializer;
    }

    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    public void setDefaultTenantId(String defaultTenantId) {
        this.defaultTenantId = defaultTenantId;
    }

    public void setSeqGenerator(SeqGenerator seqGenerator) {
        this.seqGenerator = seqGenerator;
    }

    @Override
    public void setTablePrefix(String tablePrefix) {
        super.setTablePrefix(tablePrefix);
        this.stateLogStoreSqls = new StateLogStoreSqls(tablePrefix);
    }

    private static class ResultSetToStateInstance
    implements AbstractStore.ResultSetToObject<StateInstance> {
        private ResultSetToStateInstance() {
        }

        @Override
        public StateInstance toObject(ResultSet resultSet) throws SQLException {
            StateInstanceImpl stateInstance = new StateInstanceImpl();
            stateInstance.setId(resultSet.getString("id"));
            stateInstance.setMachineInstanceId(resultSet.getString("machine_inst_id"));
            stateInstance.setName(resultSet.getString("name"));
            stateInstance.setType(resultSet.getString("type"));
            stateInstance.setBusinessKey(resultSet.getString("business_key"));
            stateInstance.setStatus(ExecutionStatus.valueOf(resultSet.getString("status")));
            stateInstance.setGmtStarted(resultSet.getTimestamp("gmt_started"));
            stateInstance.setGmtEnd(resultSet.getTimestamp("gmt_end"));
            stateInstance.setServiceName(resultSet.getString("service_name"));
            stateInstance.setServiceMethod(resultSet.getString("service_method"));
            stateInstance.setServiceType(resultSet.getString("service_type"));
            stateInstance.setForUpdate(resultSet.getBoolean("is_for_update"));
            stateInstance.setStateIdCompensatedFor(resultSet.getString("state_id_compensated_for"));
            stateInstance.setStateIdRetriedFor(resultSet.getString("state_id_retried_for"));
            stateInstance.setSerializedInputParams(resultSet.getString("input_params"));
            stateInstance.setSerializedOutputParams(resultSet.getString("output_params"));
            stateInstance.setSerializedException(resultSet.getBytes("excep"));
            return stateInstance;
        }
    }

    private static class ResultSetToStateMachineInstance
    implements AbstractStore.ResultSetToObject<StateMachineInstance> {
        private ResultSetToStateMachineInstance() {
        }

        @Override
        public StateMachineInstance toObject(ResultSet resultSet) throws SQLException {
            StateMachineInstanceImpl stateMachineInstance = new StateMachineInstanceImpl();
            stateMachineInstance.setId(resultSet.getString("id"));
            stateMachineInstance.setMachineId(resultSet.getString("machine_id"));
            stateMachineInstance.setTenantId(resultSet.getString("tenant_id"));
            stateMachineInstance.setParentId(resultSet.getString("parent_id"));
            stateMachineInstance.setBusinessKey(resultSet.getString("business_key"));
            stateMachineInstance.setGmtStarted(resultSet.getTimestamp("gmt_started"));
            stateMachineInstance.setGmtEnd(resultSet.getTimestamp("gmt_end"));
            stateMachineInstance.setStatus(ExecutionStatus.valueOf(resultSet.getString("status")));
            String compensationStatusName = resultSet.getString("compensation_status");
            if (StringUtils.hasLength((String)compensationStatusName)) {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.valueOf(compensationStatusName));
            }
            stateMachineInstance.setRunning(resultSet.getBoolean("is_running"));
            stateMachineInstance.setGmtUpdated(resultSet.getTimestamp("gmt_updated"));
            if (resultSet.getMetaData().getColumnCount() > 11) {
                stateMachineInstance.setSerializedStartParams(resultSet.getString("start_params"));
                stateMachineInstance.setSerializedEndParams(resultSet.getString("end_params"));
                stateMachineInstance.setSerializedException(resultSet.getBytes("excep"));
            }
            return stateMachineInstance;
        }
    }

    private static class StateInstanceToStatementForUpdate
    implements AbstractStore.ObjectToStatement<StateInstance> {
        private StateInstanceToStatementForUpdate() {
        }

        @Override
        public void toStatement(StateInstance stateInstance, PreparedStatement statement) throws SQLException {
            statement.setTimestamp(1, new Timestamp(stateInstance.getGmtEnd().getTime()));
            statement.setBytes(2, stateInstance.getException() != null ? (byte[])stateInstance.getSerializedException() : null);
            statement.setString(3, stateInstance.getStatus().name());
            statement.setObject(4, stateInstance.getSerializedOutputParams());
            statement.setString(5, stateInstance.getId());
            statement.setString(6, stateInstance.getMachineInstanceId());
        }
    }

    private static class StateInstanceToStatementForInsert
    implements AbstractStore.ObjectToStatement<StateInstance> {
        private StateInstanceToStatementForInsert() {
        }

        @Override
        public void toStatement(StateInstance stateInstance, PreparedStatement statement) throws SQLException {
            statement.setString(1, stateInstance.getId());
            statement.setString(2, stateInstance.getMachineInstanceId());
            statement.setString(3, stateInstance.getName());
            statement.setString(4, stateInstance.getType());
            statement.setTimestamp(5, new Timestamp(stateInstance.getGmtStarted().getTime()));
            statement.setString(6, stateInstance.getServiceName());
            statement.setString(7, stateInstance.getServiceMethod());
            statement.setString(8, stateInstance.getServiceType());
            statement.setBoolean(9, stateInstance.isForUpdate());
            statement.setObject(10, stateInstance.getSerializedInputParams());
            statement.setString(11, stateInstance.getStatus().name());
            statement.setString(12, stateInstance.getBusinessKey());
            statement.setString(13, stateInstance.getStateIdCompensatedFor());
            statement.setString(14, stateInstance.getStateIdRetriedFor());
        }
    }

    private static class StateMachineInstanceToStatementForUpdate
    implements AbstractStore.ObjectToStatement<StateMachineInstance> {
        private StateMachineInstanceToStatementForUpdate() {
        }

        @Override
        public void toStatement(StateMachineInstance stateMachineInstance, PreparedStatement statement) throws SQLException {
            statement.setTimestamp(1, new Timestamp(stateMachineInstance.getGmtEnd().getTime()));
            statement.setBytes(2, stateMachineInstance.getSerializedException() != null ? (byte[])stateMachineInstance.getSerializedException() : null);
            statement.setObject(3, stateMachineInstance.getSerializedEndParams());
            statement.setString(4, stateMachineInstance.getStatus().name());
            statement.setString(5, stateMachineInstance.getCompensationStatus() != null ? stateMachineInstance.getCompensationStatus().name() : null);
            statement.setBoolean(6, stateMachineInstance.isRunning());
            statement.setString(7, stateMachineInstance.getId());
        }
    }

    private static class StateMachineInstanceToStatementForInsert
    implements AbstractStore.ObjectToStatement<StateMachineInstance> {
        private StateMachineInstanceToStatementForInsert() {
        }

        @Override
        public void toStatement(StateMachineInstance stateMachineInstance, PreparedStatement statement) throws SQLException {
            statement.setString(1, stateMachineInstance.getId());
            statement.setString(2, stateMachineInstance.getMachineId());
            statement.setString(3, stateMachineInstance.getTenantId());
            statement.setString(4, stateMachineInstance.getParentId());
            statement.setTimestamp(5, new Timestamp(stateMachineInstance.getGmtStarted().getTime()));
            statement.setString(6, stateMachineInstance.getBusinessKey());
            statement.setObject(7, stateMachineInstance.getSerializedStartParams());
            statement.setBoolean(8, stateMachineInstance.isRunning());
            statement.setString(9, stateMachineInstance.getStatus().name());
        }
    }
}

