/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.evaluation.expression;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.evaluation.Evaluator;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.expression.Expression;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExpressionEvaluator
implements Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private Expression expression;
    private String rootObjectName = "context";

    @Override
    public boolean evaluate(Map<String, Object> variables) {
        Object result;
        block8: {
            Object rootObject;
            if (StringUtils.hasText((String)this.rootObjectName)) {
                rootObject = variables.get(this.rootObjectName);
                if (rootObject == null) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Variable [" + this.rootObjectName + "] is not exits. Cannot execute expression " + this.expression.getExpressionString() + " , return false instead.");
                    }
                    return false;
                }
            } else {
                rootObject = variables;
            }
            try {
                result = this.expression.getValue(rootObject);
            }
            catch (Exception e) {
                result = Boolean.FALSE;
                if (!LOGGER.isWarnEnabled()) break block8;
                LOGGER.warn("Expression [" + this.expression.getExpressionString() + "] execute failed, and it will return false by default. variables:" + variables, (Throwable)e);
            }
        }
        if (result == null) {
            throw new EngineExecutionException("Evaluation returns null", FrameworkErrorCode.EvaluationReturnsNull);
        }
        if (!(result instanceof Boolean)) {
            throw new EngineExecutionException("Evaluation returns non-Boolean: " + result + " (" + result.getClass().getName() + ")", FrameworkErrorCode.EvaluationReturnsNonBoolean);
        }
        return (Boolean)result;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String getRootObjectName() {
        return this.rootObjectName;
    }

    public void setRootObjectName(String rootObjectName) {
        this.rootObjectName = rootObjectName;
    }
}

