/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.druid;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import io.seata.rm.datasource.ParametersHolder;
import io.seata.rm.datasource.sql.druid.BaseRecognizer;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMySQLRecognizer
extends BaseRecognizer {
    public BaseMySQLRecognizer(String originalSql) {
        super(originalSql);
    }

    public MySqlOutputVisitor createOutputVisitor(final ParametersHolder parametersHolder, final ArrayList<List<Object>> paramAppenderList, StringBuilder sb) {
        MySqlOutputVisitor visitor = new MySqlOutputVisitor(sb){

            public boolean visit(SQLVariantRefExpr x) {
                if ("?".equals(x.getName())) {
                    ArrayList<Object> oneParamValues = parametersHolder.getParameters()[x.getIndex()];
                    if (paramAppenderList.size() == 0) {
                        oneParamValues.stream().forEach(t -> paramAppenderList.add(new ArrayList()));
                    }
                    for (int i = 0; i < oneParamValues.size(); ++i) {
                        ((List)paramAppenderList.get(i)).add(oneParamValues.get(i));
                    }
                }
                return super.visit(x);
            }
        };
        return visitor;
    }

    public String getWhereCondition(SQLExpr where, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (where == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        MySqlOutputVisitor visitor = this.createOutputVisitor(parametersHolder, paramAppenderList, sb);
        if (where instanceof SQLBinaryOpExpr) {
            visitor.visit((SQLBinaryOpExpr)where);
        } else if (where instanceof SQLInListExpr) {
            visitor.visit((SQLInListExpr)where);
        } else if (where instanceof SQLBetweenExpr) {
            visitor.visit((SQLBetweenExpr)where);
        } else {
            throw new IllegalArgumentException("unexpected WHERE expr: " + where.getClass().getSimpleName());
        }
        return sb.toString();
    }

    public String getWhereCondition(SQLExpr where) {
        if (where == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        MySqlOutputVisitor visitor = new MySqlOutputVisitor((Appendable)sb);
        if (where instanceof SQLBinaryOpExpr) {
            visitor.visit((SQLBinaryOpExpr)where);
        } else if (where instanceof SQLInListExpr) {
            visitor.visit((SQLInListExpr)where);
        } else if (where instanceof SQLBetweenExpr) {
            visitor.visit((SQLBetweenExpr)where);
        } else {
            throw new IllegalArgumentException("unexpected WHERE expr: " + where.getClass().getSimpleName());
        }
        return sb.toString();
    }
}

