/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] src) throws IOException {
        byte[] result;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(src.length);
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        try {
            gos.write(src);
            gos.finish();
            result = bos.toByteArray();
        }
        finally {
            bos.close();
            gos.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompress(byte[] src) throws IOException {
        byte[] result;
        byte[] uncompressData = new byte[src.length];
        ByteArrayInputStream bis = new ByteArrayInputStream(src);
        GZIPInputStream iis = new GZIPInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(src.length);
        try {
            int len;
            while ((len = iis.read(uncompressData, 0, uncompressData.length)) > 0) {
                bos.write(uncompressData, 0, len);
            }
            bos.flush();
            result = bos.toByteArray();
        }
        finally {
            bis.close();
            iis.close();
            bos.close();
        }
        return result;
    }

    public static boolean isCompressData(byte[] bytes) {
        if (bytes != null && bytes.length > 2) {
            int header = bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8;
            return 35615 == header;
        }
        return false;
    }
}

