/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.kryo;

import io.seata.codec.kryo.KryoSerializer;
import io.seata.codec.kryo.KryoSerializerFactory;
import io.seata.common.loader.LoadLevel;
import io.seata.core.codec.Codec;
import io.seata.core.protocol.AbstractMessage;

@LoadLevel(name="KRYO")
public class KryoCodec
implements Codec {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> byte[] encode(T t) {
        if (!(t instanceof AbstractMessage)) {
            throw new IllegalArgumentException("message is illegal");
        }
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            byte[] byArray = kryoSerializer.serialize(t);
            return byArray;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T decode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes is null");
        }
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            Object t = kryoSerializer.deserialize(bytes);
            return t;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }
}

