/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.ws.internal.WsUtils;

public class Ws7To13UpgradeHandler
extends ChannelDuplexHandler {
    private String expectedChallengeResponseString;
    private boolean upgraded;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        HttpRequest request;
        if (msg instanceof HttpRequest && (request = (HttpRequest)msg).headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, false)) {
            ChannelHandlerContext clientCodecCtx;
            byte[] nonce = WsUtils.randomBytes(16);
            String key = WsUtils.base64(nonce);
            request.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)key);
            String acceptSeed = key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            byte[] sha1 = WsUtils.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
            this.expectedChallengeResponseString = WsUtils.base64(sha1);
            String hostHeader = request.headers().get((CharSequence)HttpHeaderNames.HOST);
            if (null != hostHeader) {
                request.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)("http://" + hostHeader));
            }
            if (null == (clientCodecCtx = ctx.pipeline().context(HttpHandlerNames.HttpClientCodec.getName()))) {
                promise.tryFailure((Throwable)new IllegalStateException("Http client codec not found, can not upgrade to WebSockets."));
                return;
            }
            HttpClientCodec codec = (HttpClientCodec)clientCodecCtx.handler();
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ChannelPipeline p = future.channel().pipeline();
                        p.addAfter(clientCodecCtx.name(), HttpHandlerNames.WsClientEncoder.getName(), (ChannelHandler)new WebSocket13FrameEncoder(true));
                    }
                }
            });
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (Ws7To13UpgradeHandler.isUpgradeResponse(msg)) {
            HttpResponse response = (HttpResponse)msg;
            String accept = response.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
            if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
                throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
            }
            ChannelPipeline pipeline = ctx.pipeline();
            ChannelHandlerContext codecCtx = pipeline.context(HttpHandlerNames.HttpClientCodec.getName());
            if (null == codecCtx) {
                throw new IllegalStateException("Http codec not found, can not upgrade to WebSocket.");
            }
            pipeline.addAfter(codecCtx.name(), HttpHandlerNames.WsClientDecoder.getName(), (ChannelHandler)new WebSocket13FrameDecoder(false, false, 65555));
            pipeline.remove(HttpClientCodec.class);
            this.upgraded = true;
        }
        if (this.upgraded && msg instanceof HttpContent) {
            ((HttpContent)msg).release();
            return;
        }
        super.channelRead(ctx, msg);
    }

    private static boolean isUpgradeResponse(Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpHeaders headers = response.headers();
            return response.status().equals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS) && headers.contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && headers.contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true) && headers.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        }
        return false;
    }
}

