/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server.events;

import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventsListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SafeHttpServerEventsListener
extends HttpServerEventsListener
implements SafeEventListener {
    private final AtomicBoolean completed = new AtomicBoolean();
    private final HttpServerEventsListener delegate;

    public SafeHttpServerEventsListener(HttpServerEventsListener delegate) {
        this.delegate = delegate;
    }

    public void onCompleted() {
        if (this.completed.compareAndSet(false, true)) {
            this.delegate.onCompleted();
        }
    }

    @Override
    public void onNewRequestReceived() {
        if (!this.completed.get()) {
            this.delegate.onNewRequestReceived();
        }
    }

    @Override
    public void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onRequestHandlingStart(duration, timeUnit);
        }
    }

    @Override
    public void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onRequestHandlingSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onRequestHandlingFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onRequestHeadersReceived() {
        if (!this.completed.get()) {
            this.delegate.onRequestHeadersReceived();
        }
    }

    @Override
    public void onRequestContentReceived() {
        if (!this.completed.get()) {
            this.delegate.onRequestContentReceived();
        }
    }

    @Override
    public void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onRequestReceiveComplete(duration, timeUnit);
        }
    }

    @Override
    public void onResponseWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onResponseWriteStart();
        }
    }

    @Override
    public void onResponseWriteSuccess(long duration, TimeUnit timeUnit, int responseCode) {
        if (!this.completed.get()) {
            this.delegate.onResponseWriteSuccess(duration, timeUnit, responseCode);
        }
    }

    @Override
    public void onResponseWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onResponseWriteFailed(duration, timeUnit, throwable);
        }
    }

    public void onNewClientConnected() {
        if (!this.completed.get()) {
            this.delegate.onNewClientConnected();
        }
    }

    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingStart(duration, timeUnit);
        }
    }

    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingSuccess(duration, timeUnit);
        }
    }

    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingFailed(duration, timeUnit, throwable);
        }
    }

    public void onByteRead(long bytesRead) {
        if (!this.completed.get()) {
            this.delegate.onByteRead(bytesRead);
        }
    }

    public void onByteWritten(long bytesWritten) {
        if (!this.completed.get()) {
            this.delegate.onByteWritten(bytesWritten);
        }
    }

    public void onFlushStart() {
        if (!this.completed.get()) {
            this.delegate.onFlushStart();
        }
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onFlushComplete(duration, timeUnit);
        }
    }

    public void onWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onWriteStart();
        }
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onWriteSuccess(duration, timeUnit);
        }
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onWriteFailed(duration, timeUnit, throwable);
        }
    }

    public void onConnectionCloseStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseStart();
        }
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseSuccess(duration, timeUnit);
        }
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseFailed(duration, timeUnit, throwable);
        }
    }

    public void onCustomEvent(Object event) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit, throwable);
        }
    }

    public void onCustomEvent(Object event, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, throwable);
        }
    }

    public HttpServerEventsListener unwrap() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeHttpServerEventsListener)) {
            return false;
        }
        SafeHttpServerEventsListener that = (SafeHttpServerEventsListener)((Object)o);
        return !(this.delegate == null ? that.delegate != null : !((Object)((Object)this.delegate)).equals((Object)that.delegate));
    }

    public int hashCode() {
        return this.delegate != null ? ((Object)((Object)this.delegate)).hashCode() : 0;
    }
}

