/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.internal;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.channel.AppendTransformerEvent;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.events.Clock;
import io.reactivex.netty.events.EventAttributeKeys;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.internal.VoidToAnythingCast;
import io.reactivex.netty.protocol.http.TrailingHeaders;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import io.reactivex.netty.protocol.http.client.internal.HttpChannelProvider;
import io.reactivex.netty.protocol.http.client.internal.HttpClientResponseImpl;
import io.reactivex.netty.protocol.http.client.internal.RawRequest;
import io.reactivex.netty.protocol.http.client.internal.Redirector;
import io.reactivex.netty.protocol.http.internal.OperatorTrailer;
import io.reactivex.netty.protocol.http.ws.client.internal.WebSocketRequestImpl;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public final class HttpClientRequestImpl<I, O>
extends HttpClientRequest<I, O> {
    public static final int NO_REDIRECTS = -1;
    private final List<AppendTransformerEvent> immutableTransformers;
    private final List<Observable.Transformer> immutableResponseTransformers;
    private final RawRequest<I, O> rawRequest;
    private final TcpClient<?, HttpClientResponse<O>> client;
    private final Func1<I, Boolean> flushOnEachSelector = new Func1<I, Boolean>(){

        public Boolean call(I next) {
            return true;
        }
    };

    private HttpClientRequestImpl(RawRequest<I, O> rawRequest, TcpClient<?, HttpClientResponse<O>> client, List<AppendTransformerEvent> immutableTransformers, List<Observable.Transformer> immutableResponseTransformers) {
        super(new OnSubscribeFuncImpl<I, O>(client, rawRequest, immutableResponseTransformers, immutableTransformers));
        this.rawRequest = rawRequest;
        this.client = client;
        this.immutableTransformers = immutableTransformers;
        this.immutableResponseTransformers = immutableResponseTransformers;
    }

    @Override
    public Observable<HttpClientResponse<O>> writeContent(Observable<I> contentSource) {
        Observable<I> rawObservable = contentSource;
        return this._writeContentRaw(rawObservable, false);
    }

    @Override
    public Observable<HttpClientResponse<O>> writeContentAndFlushOnEach(Observable<I> contentSource) {
        return this.writeContent(contentSource, this.flushOnEachSelector);
    }

    @Override
    public Observable<HttpClientResponse<O>> writeStringContent(Observable<String> contentSource) {
        Observable<String> rawObservable = contentSource;
        return this._writeContentRaw(rawObservable, false);
    }

    @Override
    public Observable<HttpClientResponse<O>> writeBytesContent(Observable<byte[]> contentSource) {
        Observable<byte[]> rawObservable = contentSource;
        return this._writeContentRaw(rawObservable, false);
    }

    @Override
    public Observable<HttpClientResponse<O>> writeContent(Observable<I> contentSource, Func1<I, Boolean> flushSelector) {
        Observable<I> rawObservable = contentSource;
        return this._writeContentRaw(rawObservable, flushSelector, false);
    }

    @Override
    public Observable<HttpClientResponse<O>> writeStringContent(Observable<String> contentSource, Func1<String, Boolean> flushSelector) {
        Observable<String> rawObservable = contentSource;
        return this._writeContentRaw(rawObservable, flushSelector, false);
    }

    @Override
    public Observable<HttpClientResponse<O>> writeBytesContent(Observable<byte[]> contentSource, Func1<byte[], Boolean> flushSelector) {
        Observable<byte[]> rawObservable = contentSource;
        return this._writeContentRaw(rawObservable, flushSelector, false);
    }

    @Override
    public <T extends TrailingHeaders> Observable<HttpClientResponse<O>> writeContent(Observable<I> contentSource, Func0<T> trailerFactory, Func2<T, I, T> trailerMutator) {
        Observable<I> rawObservable = contentSource;
        return this._writeContentRaw(OperatorTrailer.liftFrom(rawObservable, trailerFactory, trailerMutator), true);
    }

    @Override
    public <T extends TrailingHeaders> Observable<HttpClientResponse<O>> writeStringContent(Observable<String> contentSource, Func0<T> trailerFactory, Func2<T, String, T> trailerMutator) {
        Observable<String> rawObservable = contentSource;
        return this._writeContentRaw(OperatorTrailer.liftFrom(rawObservable, trailerFactory, trailerMutator), true);
    }

    @Override
    public <T extends TrailingHeaders> Observable<HttpClientResponse<O>> writeBytesContent(Observable<byte[]> contentSource, Func0<T> trailerFactory, Func2<T, byte[], T> trailerMutator) {
        Observable<byte[]> rawObservable = contentSource;
        return this._writeContentRaw(OperatorTrailer.liftFrom(rawObservable, trailerFactory, trailerMutator), true);
    }

    @Override
    public <T extends TrailingHeaders> Observable<HttpClientResponse<O>> writeContent(Observable<I> contentSource, Func0<T> trailerFactory, Func2<T, I, T> trailerMutator, Func1<I, Boolean> flushSelector) {
        Observable<I> rawObservable = contentSource;
        return this._writeContentRaw(OperatorTrailer.liftFrom(rawObservable, trailerFactory, trailerMutator), flushSelector, true);
    }

    @Override
    public <T extends TrailingHeaders> Observable<HttpClientResponse<O>> writeStringContent(Observable<String> contentSource, Func0<T> trailerFactory, Func2<T, String, T> trailerMutator, Func1<String, Boolean> flushSelector) {
        Observable<String> rawObservable = contentSource;
        return this._writeContentRaw(OperatorTrailer.liftFrom(rawObservable, trailerFactory, trailerMutator), flushSelector, true);
    }

    @Override
    public <T extends TrailingHeaders> Observable<HttpClientResponse<O>> writeBytesContent(Observable<byte[]> contentSource, Func0<T> trailerFactory, Func2<T, byte[], T> trailerMutator, Func1<byte[], Boolean> flushSelector) {
        Observable<byte[]> rawObservable = contentSource;
        return this._writeContentRaw(OperatorTrailer.liftFrom(rawObservable, trailerFactory, trailerMutator), flushSelector, true);
    }

    @Override
    public HttpClientRequestImpl<I, O> readTimeOut(int timeOut, TimeUnit timeUnit) {
        return this._copy(this.client.readTimeOut(timeOut, timeUnit));
    }

    @Override
    public HttpClientRequestImpl<I, O> followRedirects(int maxRedirects) {
        Redirector<I, O> redirector = new Redirector<I, O>(maxRedirects, this.client);
        HttpClientRequestImpl<I, O> toReturn = this._copy(this.client, this.rawRequest.followRedirect(redirector));
        redirector.setOriginalRequest(toReturn.rawRequest);
        return toReturn;
    }

    @Override
    public HttpClientRequestImpl<I, O> followRedirects(boolean follow) {
        return follow ? this.followRedirects(5) : this.followRedirects(-1);
    }

    @Override
    public HttpClientRequestImpl<I, O> setMethod(HttpMethod method) {
        return this._copy(this.client, this.rawRequest.setMethod(method));
    }

    @Override
    public HttpClientRequestImpl<I, O> setUri(String newUri) {
        return this._copy(this.client, this.rawRequest.setUri(newUri));
    }

    @Override
    public HttpClientRequestImpl<I, O> addHeader(CharSequence name, Object value) {
        return this._copy(this.client, this.rawRequest.addHeader(name, value));
    }

    @Override
    public HttpClientRequest<I, O> addHeaders(Map<? extends CharSequence, ? extends Iterable<Object>> headers) {
        return this._copy(this.client, this.rawRequest.addHeaders(headers));
    }

    @Override
    public HttpClientRequestImpl<I, O> addCookie(Cookie cookie) {
        return this._copy(this.client, this.rawRequest.addCookie(cookie));
    }

    @Override
    public HttpClientRequestImpl<I, O> addDateHeader(CharSequence name, Date value) {
        return this._copy(this.client, this.rawRequest.addDateHeader(name, value));
    }

    @Override
    public HttpClientRequestImpl<I, O> addDateHeader(CharSequence name, Iterable<Date> values) {
        return this._copy(this.client, this.rawRequest.addDateHeader(name, values));
    }

    @Override
    public HttpClientRequestImpl<I, O> addHeaderValues(CharSequence name, Iterable<Object> values) {
        return this._copy(this.client, this.rawRequest.addHeaderValues(name, values));
    }

    @Override
    public HttpClientRequestImpl<I, O> setDateHeader(CharSequence name, Date value) {
        return this._copy(this.client, this.rawRequest.setDateHeader(name, value));
    }

    @Override
    public HttpClientRequestImpl<I, O> setHeader(CharSequence name, Object value) {
        return this._copy(this.client, this.rawRequest.setHeader(name, value));
    }

    @Override
    public HttpClientRequest<I, O> setHeaders(Map<? extends CharSequence, ? extends Iterable<Object>> headers) {
        return this._copy(this.client, this.rawRequest.setHeaders(headers));
    }

    @Override
    public HttpClientRequestImpl<I, O> setDateHeader(CharSequence name, Iterable<Date> values) {
        return this._copy(this.client, this.rawRequest.setDateHeader(name, values));
    }

    @Override
    public HttpClientRequestImpl<I, O> setHeaderValues(CharSequence name, Iterable<Object> values) {
        return this._copy(this.client, this.rawRequest.setHeaderValues(name, values));
    }

    @Override
    public HttpClientRequestImpl<I, O> removeHeader(CharSequence name) {
        return this._copy(this.client, this.rawRequest.removeHeader(name));
    }

    @Override
    public HttpClientRequestImpl<I, O> setKeepAlive(boolean keepAlive) {
        return this._copy(this.client, this.rawRequest.setKeepAlive(keepAlive));
    }

    @Override
    public HttpClientRequestImpl<I, O> setTransferEncodingChunked() {
        return this._copy(this.client, this.rawRequest.setTransferEncodingChunked());
    }

    @Override
    public <II> HttpClientRequestImpl<II, O> transformContent(AllocatingTransformer<II, I> transformer) {
        ArrayList<AppendTransformerEvent> newTransformers = new ArrayList<AppendTransformerEvent>(this.immutableTransformers);
        AppendTransformerEvent e = new AppendTransformerEvent(transformer);
        newTransformers.add(e);
        RawRequest<I, O> cast = this.rawRequest;
        return new HttpClientRequestImpl<I, O>(cast, this.client, newTransformers, this.immutableResponseTransformers);
    }

    @Override
    public <OO> HttpClientRequestImpl<I, OO> transformResponseContent(Observable.Transformer<O, OO> transformer) {
        TcpClient<?, HttpClientResponse<O>> rawClient;
        ArrayList<Observable.Transformer> newTransformers = new ArrayList<Observable.Transformer>(this.immutableResponseTransformers);
        newTransformers.add(transformer);
        RawRequest<I, O> cast = this.rawRequest;
        TcpClient<?, HttpClientResponse<O>> _client = rawClient = this.client;
        return new HttpClientRequestImpl<I, O>(cast, _client, this.immutableTransformers, newTransformers);
    }

    @Override
    public WebSocketRequestImpl<O> requestWebSocketUpgrade() {
        return WebSocketRequestImpl.createNew(this);
    }

    @Override
    public boolean containsHeader(CharSequence name) {
        return this.rawRequest.getHeaders().headers().contains(name);
    }

    @Override
    public boolean containsHeaderWithValue(CharSequence name, CharSequence value, boolean caseInsensitiveValueMatch) {
        return this.rawRequest.getHeaders().headers().contains(name, value, caseInsensitiveValueMatch);
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.rawRequest.getHeaders().headers().get(name);
    }

    @Override
    public List<String> getAllHeaders(CharSequence name) {
        return this.rawRequest.getHeaders().headers().getAll(name);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> headerIterator() {
        return this.rawRequest.getHeaders().headers().iteratorCharSequence();
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.rawRequest.getHeaders().headers().names();
    }

    @Override
    public HttpVersion getHttpVersion() {
        return this.rawRequest.getHeaders().protocolVersion();
    }

    @Override
    public HttpMethod getMethod() {
        return this.rawRequest.getHeaders().method();
    }

    @Override
    public String getUri() {
        return this.rawRequest.getHeaders().uri();
    }

    public static <I, O> HttpClientRequestImpl<I, O> create(HttpVersion version, HttpMethod httpMethod, String uri, TcpClient<?, HttpClientResponse<O>> client, int maxRedirects) {
        Redirector redirector = -1 == maxRedirects ? null : new Redirector(maxRedirects, client);
        RawRequest rawRequest = RawRequest.create(version, httpMethod, uri, redirector);
        if (null != redirector) {
            redirector.setOriginalRequest(rawRequest);
        }
        return HttpClientRequestImpl.create(rawRequest, client);
    }

    public static <I, O> HttpClientRequestImpl<I, O> create(HttpVersion version, HttpMethod httpMethod, String uri, TcpClient<?, HttpClientResponse<O>> client) {
        return HttpClientRequestImpl.create(version, httpMethod, uri, client, -1);
    }

    public static <I, O> HttpClientRequestImpl<I, O> create(RawRequest<I, O> rawRequest, TcpClient<?, HttpClientResponse<O>> client) {
        return new HttpClientRequestImpl<I, O>(rawRequest, client, Collections.emptyList(), Collections.emptyList());
    }

    public TcpClient<?, HttpClientResponse<O>> getClient() {
        return this.client;
    }

    private <II, OO> HttpClientRequestImpl<II, OO> _copy(TcpClient<?, HttpClientResponse<OO>> c) {
        return this._copy(c, this.rawRequest);
    }

    private <II, OO> HttpClientRequestImpl<II, OO> _copy(TcpClient<?, HttpClientResponse<OO>> c, RawRequest<II, OO> rawRequest) {
        return new HttpClientRequestImpl<II, OO>(rawRequest, c, this.immutableTransformers, this.immutableResponseTransformers);
    }

    private Observable<HttpClientResponse<O>> _writeContentRaw(Observable rawContent, boolean hasTrailers) {
        return this._writeContentRaw(rawContent, null, hasTrailers);
    }

    private Observable<HttpClientResponse<O>> _writeContentRaw(Observable rawContent, Func1<?, Boolean> flushSelector, boolean hasTrailers) {
        RawRequest<I, O> r = RawRequest.create(this.rawRequest.getHeaders(), rawContent, flushSelector, hasTrailers, this.rawRequest.getRedirector());
        return new HttpClientRequestImpl<I, O>(r, this.client, this.immutableTransformers, this.immutableResponseTransformers);
    }

    public RawRequest<I, O> unsafeRawRequest() {
        return this.rawRequest;
    }

    private static class RequestWriteMetricsOperator
    implements Observable.Operator<Void, Void> {
        private final EventPublisher eventPublisher;
        private final HttpClientEventsListener eventsListener;

        public RequestWriteMetricsOperator(HttpClientEventsListener eventsListener, EventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
            this.eventsListener = eventsListener;
        }

        public Subscriber<? super Void> call(final Subscriber<? super Void> o) {
            long startTimeNanos;
            long l = startTimeNanos = this.eventPublisher.publishingEnabled() ? Clock.newStartTimeNanos() : -1L;
            if (this.eventPublisher.publishingEnabled()) {
                this.eventsListener.onRequestSubmitted();
            }
            return new Subscriber<Void>(o){

                public void onCompleted() {
                    if (RequestWriteMetricsOperator.this.eventPublisher.publishingEnabled()) {
                        RequestWriteMetricsOperator.this.eventsListener.onRequestWriteComplete(Clock.onEndNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
                    }
                    o.onCompleted();
                }

                public void onError(Throwable e) {
                    if (RequestWriteMetricsOperator.this.eventPublisher.publishingEnabled()) {
                        RequestWriteMetricsOperator.this.eventsListener.onRequestWriteFailed(Clock.onEndNanos((long)startTimeNanos), TimeUnit.NANOSECONDS, e);
                    }
                    o.onError(e);
                }

                public void onNext(Void aVoid) {
                    o.onNext((Object)aVoid);
                }
            };
        }
    }

    private static class ConnToResponseFunc<I, O>
    implements Func1<Connection<HttpClientResponse<O>, ?>, Observable<HttpClientResponse<O>>> {
        private final RawRequest<I, O> rawRequest;
        private List<Observable.Transformer> responseTransformers;
        private List<AppendTransformerEvent> requestTransformers;

        public ConnToResponseFunc(RawRequest<I, O> rawRequest, List<Observable.Transformer> responseTransformers, List<AppendTransformerEvent> requestTransformers) {
            this.rawRequest = rawRequest;
            this.responseTransformers = responseTransformers;
            this.requestTransformers = requestTransformers;
        }

        public Observable<HttpClientResponse<O>> call(final Connection<HttpClientResponse<O>, ?> conn) {
            for (AppendTransformerEvent requestTransformer : this.requestTransformers) {
                conn.unsafeNettyChannel().pipeline().fireUserEventTriggered((Object)requestTransformer);
            }
            ContentSource input = conn.getInput();
            HttpClientEventsListener eventsListener = (HttpClientEventsListener)((Object)conn.unsafeNettyChannel().attr(HttpChannelProvider.HTTP_CLIENT_EVENT_LISTENER).get());
            EventPublisher eventPublisher = (EventPublisher)conn.unsafeNettyChannel().attr(EventAttributeKeys.EVENT_PUBLISHER).get();
            return this.writeRequest(conn).lift((Observable.Operator)new RequestWriteMetricsOperator(eventsListener, eventPublisher)).map((Func1)new VoidToAnythingCast()).ignoreElements().concatWith(input.take(1)).map(new Func1<HttpClientResponse<O>, HttpClientResponse<O>>(){

                public HttpClientResponse<O> call(HttpClientResponse<O> r) {
                    HttpClientResponse<Object> rp = HttpClientResponseImpl.newInstance(r, conn);
                    for (Observable.Transformer transformer : ConnToResponseFunc.this.responseTransformers) {
                        rp = rp.transformContent(transformer);
                    }
                    return rp;
                }
            });
        }

        protected Observable<Void> writeRequest(Connection<HttpClientResponse<O>, ?> conn) {
            return conn.write(this.rawRequest.asObservable(conn));
        }
    }

    private static class OnSubscribeFuncImpl<I, O>
    implements Observable.OnSubscribe<HttpClientResponse<O>> {
        private final Observable source;
        private final TcpClient<?, HttpClientResponse<O>> client;

        public OnSubscribeFuncImpl(TcpClient<?, HttpClientResponse<O>> client, RawRequest<I, O> rawRequest, List<Observable.Transformer> responseTransformers, List<AppendTransformerEvent> requestTransformers) {
            this.client = client;
            ConnToResponseFunc<I, O> connToResponseFunc = new ConnToResponseFunc<I, O>(rawRequest, responseTransformers, requestTransformers);
            Observable source = this.client.createConnectionRequest().take(1).switchMap(connToResponseFunc);
            if (null != rawRequest.getRedirector()) {
                source = source.switchMap(rawRequest.getRedirector());
            }
            this.source = source;
        }

        public void call(Subscriber<? super HttpClientResponse<O>> subscriber) {
            Subscriber<? super HttpClientResponse<O>> rawSub = subscriber;
            this.source.unsafeSubscribe(rawSub);
        }
    }
}

