/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.reactivex.netty.protocol.http.client.HttpClientInterceptorChain;
import io.reactivex.netty.protocol.http.client.HttpClientInterceptorChainImpl;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.InterceptingHttpClient;
import io.reactivex.netty.protocol.http.client.RequestProvider;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventPublisher;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import rx.Subscription;

class InterceptingHttpClientImpl<I, O>
extends InterceptingHttpClient<I, O> {
    private final RequestProvider<I, O> requestProvider;
    private final HttpClientEventPublisher cep;

    public InterceptingHttpClientImpl(RequestProvider<I, O> requestProvider, HttpClientEventPublisher cep) {
        this.requestProvider = requestProvider;
        this.cep = cep;
    }

    @Override
    public HttpClientRequest<I, O> createGet(String uri) {
        return this.createRequest(HttpMethod.GET, uri);
    }

    @Override
    public HttpClientRequest<I, O> createPost(String uri) {
        return this.createRequest(HttpMethod.POST, uri);
    }

    @Override
    public HttpClientRequest<I, O> createPut(String uri) {
        return this.createRequest(HttpMethod.PUT, uri);
    }

    @Override
    public HttpClientRequest<I, O> createDelete(String uri) {
        return this.createRequest(HttpMethod.DELETE, uri);
    }

    @Override
    public HttpClientRequest<I, O> createHead(String uri) {
        return this.createRequest(HttpMethod.HEAD, uri);
    }

    @Override
    public HttpClientRequest<I, O> createOptions(String uri) {
        return this.createRequest(HttpMethod.OPTIONS, uri);
    }

    @Override
    public HttpClientRequest<I, O> createPatch(String uri) {
        return this.createRequest(HttpMethod.PATCH, uri);
    }

    @Override
    public HttpClientRequest<I, O> createTrace(String uri) {
        return this.createRequest(HttpMethod.TRACE, uri);
    }

    @Override
    public HttpClientRequest<I, O> createConnect(String uri) {
        return this.createRequest(HttpMethod.CONNECT, uri);
    }

    @Override
    public HttpClientRequest<I, O> createRequest(HttpMethod method, String uri) {
        return this.createRequest(HttpVersion.HTTP_1_1, method, uri);
    }

    @Override
    public HttpClientRequest<I, O> createRequest(HttpVersion version, HttpMethod method, String uri) {
        return this.requestProvider.createRequest(version, method, uri);
    }

    @Override
    public HttpClientInterceptorChain<I, O> intercept() {
        return new HttpClientInterceptorChainImpl<I, O>(this.requestProvider, this.cep);
    }

    public Subscription subscribe(HttpClientEventsListener listener) {
        return this.cep.subscribe(listener);
    }
}

