/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.logging.Logger;

class InstanceHandleImpl<T>
implements InstanceHandle<T> {
    private static final Logger LOGGER = Logger.getLogger((String)InstanceHandleImpl.class.getName());
    static final InstanceHandleImpl<Object> UNAVAILABLE = new InstanceHandleImpl<Object>(null, null, null, null, null);
    private final InjectableBean<T> bean;
    private final T instance;
    private final CreationalContext<T> creationalContext;
    private final CreationalContext<?> parentCreationalContext;
    private final AtomicBoolean destroyed;
    private final Consumer<T> destroyLogic;

    public static final <T> InstanceHandle<T> unavailable() {
        return UNAVAILABLE;
    }

    InstanceHandleImpl(InjectableBean<T> bean, T instance, CreationalContext<T> creationalContext) {
        this(bean, instance, creationalContext, null, null);
    }

    InstanceHandleImpl(InjectableBean<T> bean, T instance, CreationalContext<T> creationalContext, CreationalContext<?> parentCreationalContext, Consumer<T> destroyLogic) {
        this.bean = bean;
        this.instance = instance;
        this.creationalContext = creationalContext;
        this.parentCreationalContext = parentCreationalContext;
        this.destroyed = new AtomicBoolean(false);
        this.destroyLogic = destroyLogic;
    }

    @Override
    public T get() {
        if (this.destroyed.get()) {
            throw new IllegalStateException("Instance already destroyed");
        }
        return this.instance;
    }

    @Override
    public InjectableBean<T> getBean() {
        return this.bean;
    }

    @Override
    public void destroy() {
        if (this.instance != null && this.destroyed.compareAndSet(false, true)) {
            if (this.destroyLogic != null) {
                this.destroyLogic.accept(this.instance);
            } else if (this.bean.getScope().equals(Dependent.class)) {
                this.destroyInternal();
            } else {
                InjectableContext context = Arc.container().getActiveContext(this.bean.getScope());
                if (context == null) {
                    throw new ContextNotActiveException("Cannot destroy instance of " + this.bean + " - no active context found for: " + this.bean.getScope());
                }
                context.destroy((Contextual)this.bean);
            }
        }
    }

    protected void destroyInternal() {
        if (this.parentCreationalContext != null) {
            this.parentCreationalContext.release();
        } else {
            try {
                this.bean.destroy(this.instance, this.creationalContext);
            }
            catch (Throwable t) {
                String msg = "Error occured while destroying instance of bean [%s]";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.errorf(t, msg, (Object)this.bean.getClass().getName());
                }
                LOGGER.errorf(msg + ": %s", (Object)this.bean.getClass().getName(), (Object)t);
            }
        }
    }

    public String toString() {
        return "InstanceHandleImpl [bean=" + this.bean + ", instance=" + this.instance + ", creationalContext=" + this.creationalContext + ", parentCreationalContext=" + this.parentCreationalContext + ", destroyed=" + this.destroyed + "]";
    }
}

