/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.CovariantTypes;
import io.quarkus.arc.impl.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;

final class BeanTypeAssignabilityRules {
    private BeanTypeAssignabilityRules() {
    }

    static boolean matches(Type requiredType, Set<? extends Type> beanTypes) {
        for (Type type : beanTypes) {
            if (!BeanTypeAssignabilityRules.matches(requiredType, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(Type requiredType, Type beanType) {
        return BeanTypeAssignabilityRules.matchesNoBoxing(Types.boxedType(requiredType), Types.boxedType(beanType));
    }

    private static boolean matchesNoBoxing(Type requiredType, Type beanType) {
        if (requiredType instanceof Class) {
            if (beanType instanceof Class) {
                return BeanTypeAssignabilityRules.matches((Class)requiredType, (Class)beanType);
            }
            if (beanType instanceof ParameterizedType) {
                return BeanTypeAssignabilityRules.matches((Class)requiredType, (ParameterizedType)beanType);
            }
        } else if (requiredType instanceof ParameterizedType) {
            if (beanType instanceof Class) {
                return BeanTypeAssignabilityRules.matches((Class)beanType, (ParameterizedType)requiredType);
            }
            if (beanType instanceof ParameterizedType) {
                return BeanTypeAssignabilityRules.matches((ParameterizedType)requiredType, (ParameterizedType)beanType);
            }
        }
        return false;
    }

    private static boolean matches(Class<?> requiredType, Class<?> beanType) {
        return requiredType.equals(beanType);
    }

    private static boolean matches(Class<?> type1, ParameterizedType type2) {
        if (!type1.equals(Types.getRawType(type2))) {
            return false;
        }
        return Types.isArrayOfUnboundedTypeVariablesOrObjects(type2.getActualTypeArguments());
    }

    private static boolean matches(ParameterizedType requiredType, ParameterizedType beanType) {
        if (!requiredType.getRawType().equals(beanType.getRawType())) {
            return false;
        }
        if (requiredType.getActualTypeArguments().length != beanType.getActualTypeArguments().length) {
            throw new IllegalArgumentException("Invalid argument combination " + requiredType + "; " + beanType);
        }
        for (int i = 0; i < requiredType.getActualTypeArguments().length; ++i) {
            if (BeanTypeAssignabilityRules.parametersMatch(requiredType.getActualTypeArguments()[i], beanType.getActualTypeArguments()[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersMatch(Type requiredParameter, Type beanParameter) {
        if (Types.isActualType(requiredParameter) && Types.isActualType(beanParameter)) {
            return BeanTypeAssignabilityRules.matches(requiredParameter, beanParameter);
        }
        if (requiredParameter instanceof WildcardType && Types.isActualType(beanParameter)) {
            return BeanTypeAssignabilityRules.parametersMatch((WildcardType)requiredParameter, beanParameter);
        }
        if (requiredParameter instanceof WildcardType && beanParameter instanceof TypeVariable) {
            return BeanTypeAssignabilityRules.parametersMatch((WildcardType)requiredParameter, (TypeVariable)beanParameter);
        }
        if (Types.isActualType(requiredParameter) && beanParameter instanceof TypeVariable) {
            return BeanTypeAssignabilityRules.parametersMatch(requiredParameter, (TypeVariable)beanParameter);
        }
        if (requiredParameter instanceof TypeVariable && beanParameter instanceof TypeVariable) {
            return BeanTypeAssignabilityRules.parametersMatch((TypeVariable)requiredParameter, (TypeVariable)beanParameter);
        }
        return false;
    }

    private static boolean parametersMatch(WildcardType requiredParameter, Type beanParameter) {
        return BeanTypeAssignabilityRules.lowerBoundsOfWildcardMatch(beanParameter, requiredParameter) && BeanTypeAssignabilityRules.upperBoundsOfWildcardMatch(requiredParameter, beanParameter);
    }

    private static boolean parametersMatch(WildcardType requiredParameter, TypeVariable<?> beanParameter) {
        Type[] beanParameterBounds = BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(beanParameter);
        if (!BeanTypeAssignabilityRules.lowerBoundsOfWildcardMatch(beanParameterBounds, requiredParameter)) {
            return false;
        }
        Type[] requiredUpperBounds = requiredParameter.getUpperBounds();
        return BeanTypeAssignabilityRules.boundsMatch(requiredUpperBounds, beanParameterBounds) || BeanTypeAssignabilityRules.boundsMatch(beanParameterBounds, requiredUpperBounds);
    }

    private static boolean parametersMatch(Type requiredParameter, TypeVariable<?> beanParameter) {
        for (Type bound : BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(beanParameter)) {
            if (CovariantTypes.isAssignableFrom(bound, requiredParameter)) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersMatch(TypeVariable<?> requiredParameter, TypeVariable<?> beanParameter) {
        return BeanTypeAssignabilityRules.boundsMatch(BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(beanParameter), BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(requiredParameter));
    }

    static Type[] getUppermostTypeVariableBounds(TypeVariable<?> bound) {
        if (bound.getBounds()[0] instanceof TypeVariable) {
            return BeanTypeAssignabilityRules.getUppermostTypeVariableBounds((TypeVariable)bound.getBounds()[0]);
        }
        return bound.getBounds();
    }

    private static Type[] getUppermostBounds(Type[] bounds) {
        if (bounds[0] instanceof TypeVariable) {
            return BeanTypeAssignabilityRules.getUppermostTypeVariableBounds((TypeVariable)bounds[0]);
        }
        return bounds;
    }

    private static boolean boundsMatch(Type[] upperBounds, Type[] stricterUpperBounds) {
        upperBounds = BeanTypeAssignabilityRules.getUppermostBounds(upperBounds);
        stricterUpperBounds = BeanTypeAssignabilityRules.getUppermostBounds(stricterUpperBounds);
        for (Type upperBound : upperBounds) {
            if (CovariantTypes.isAssignableFromAtLeastOne(upperBound, stricterUpperBounds)) continue;
            return false;
        }
        return true;
    }

    static boolean lowerBoundsOfWildcardMatch(Type parameter, WildcardType requiredParameter) {
        return BeanTypeAssignabilityRules.lowerBoundsOfWildcardMatch(new Type[]{parameter}, requiredParameter);
    }

    static boolean lowerBoundsOfWildcardMatch(Type[] beanParameterBounds, WildcardType requiredParameter) {
        Type[] lowerBounds;
        return requiredParameter.getLowerBounds().length <= 0 || BeanTypeAssignabilityRules.boundsMatch(beanParameterBounds, lowerBounds = requiredParameter.getLowerBounds());
    }

    static boolean upperBoundsOfWildcardMatch(WildcardType requiredParameter, Type parameter) {
        return BeanTypeAssignabilityRules.boundsMatch(requiredParameter.getUpperBounds(), new Type[]{parameter});
    }
}

