/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jersey2.server;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.uri.UriTemplate;

public final class JerseyTags {
    private static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    private static final Tag URI_ROOT = Tag.of((String)"uri", (String)"root");
    private static final Tag EXCEPTION_NONE = Tag.of((String)"exception", (String)"None");
    private static final Tag STATUS_SERVER_ERROR = Tag.of((String)"status", (String)String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()));
    private static final Tag OUTCOME_UNKNOWN = Tag.of((String)"outcome", (String)"UNKNOWN");
    private static final Tag OUTCOME_INFORMATIONAL = Tag.of((String)"outcome", (String)"INFORMATIONAL");
    private static final Tag OUTCOME_SUCCESS = Tag.of((String)"outcome", (String)"SUCCESS");
    private static final Tag OUTCOME_REDIRECTION = Tag.of((String)"outcome", (String)"REDIRECTION");
    private static final Tag OUTCOME_CLIENT_ERROR = Tag.of((String)"outcome", (String)"CLIENT_ERROR");
    private static final Tag OUTCOME_SERVER_ERROR = Tag.of((String)"outcome", (String)"SERVER_ERROR");
    private static final Tag METHOD_UNKNOWN = Tag.of((String)"method", (String)"UNKNOWN");
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    private JerseyTags() {
    }

    public static Tag method(ContainerRequest request) {
        return request != null ? Tag.of((String)"method", (String)request.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag status(ContainerResponse response) {
        return response != null ? Tag.of((String)"status", (String)Integer.toString(response.getStatus())) : STATUS_SERVER_ERROR;
    }

    public static Tag uri(RequestEvent event) {
        String matchingPattern;
        ContainerResponse response = event.getContainerResponse();
        if (response != null) {
            int status = response.getStatus();
            if (JerseyTags.isRedirection(status)) {
                return URI_REDIRECTION;
            }
            if (status == 404) {
                return URI_NOT_FOUND;
            }
        }
        if ((matchingPattern = JerseyTags.getMatchingPattern(event)).equals("/")) {
            return URI_ROOT;
        }
        return Tag.of((String)"uri", (String)matchingPattern);
    }

    private static boolean isRedirection(int status) {
        return Response.Status.Family.familyOf((int)status) == Response.Status.Family.REDIRECTION;
    }

    private static String getMatchingPattern(RequestEvent event) {
        ExtendedUriInfo uriInfo = event.getUriInfo();
        List templates = uriInfo.getMatchedTemplates();
        StringBuilder sb = new StringBuilder();
        sb.append(uriInfo.getBaseUri().getPath());
        for (int i = templates.size() - 1; i >= 0; --i) {
            sb.append(((UriTemplate)templates.get(i)).getTemplate());
        }
        String multipleSlashCleaned = MULTIPLE_SLASH_PATTERN.matcher(sb.toString()).replaceAll("/");
        if (multipleSlashCleaned.equals("/")) {
            return multipleSlashCleaned;
        }
        return TRAILING_SLASH_PATTERN.matcher(multipleSlashCleaned).replaceAll("");
    }

    public static Tag exception(RequestEvent event) {
        String simpleName;
        int status;
        Throwable exception = event.getException();
        if (exception == null) {
            return EXCEPTION_NONE;
        }
        ContainerResponse response = event.getContainerResponse();
        if (response != null && ((status = response.getStatus()) == 404 || JerseyTags.isRedirection(status))) {
            return EXCEPTION_NONE;
        }
        if (exception.getCause() != null) {
            exception = exception.getCause();
        }
        return Tag.of((String)"exception", (String)(StringUtils.isNotEmpty((String)(simpleName = exception.getClass().getSimpleName())) ? simpleName : exception.getClass().getName()));
    }

    public static Tag outcome(ContainerResponse response) {
        if (response != null) {
            int status = response.getStatus();
            switch (Response.Status.Family.familyOf((int)status)) {
                case INFORMATIONAL: {
                    return OUTCOME_INFORMATIONAL;
                }
                case SUCCESSFUL: {
                    return OUTCOME_SUCCESS;
                }
                case REDIRECTION: {
                    return OUTCOME_REDIRECTION;
                }
                case CLIENT_ERROR: {
                    return OUTCOME_CLIENT_ERROR;
                }
                case SERVER_ERROR: {
                    return OUTCOME_SERVER_ERROR;
                }
            }
            return OUTCOME_UNKNOWN;
        }
        return OUTCOME_SERVER_ERROR;
    }
}

