/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSeekableByteChannel
implements SeekableByteChannel {
    private static final Logger logger = LoggerFactory.getLogger(HttpSeekableByteChannel.class);
    private static final int DEFAULT_BLOCK_SIZE = 131072;
    private static final int DEFAULT_CACHE_SIZE_MB = 16;
    private static final int DEFAULT_MAX_CACHE_BLOCKS = 128;
    private static final int MAX_RETRIES = 3;
    private final URL url;
    private final long size;
    private final int blockSize;
    private final LruCache<Long, byte[]> cache;
    private final ReentrantLock lock = new ReentrantLock();
    private long position = 0L;
    private volatile boolean open = true;
    private long totalBytesRead = 0L;
    private int totalBlocksFetched = 0;
    private int cacheHits = 0;
    private int cacheMisses = 0;

    public HttpSeekableByteChannel(URL url) throws IOException {
        this(url, 131072, 128);
    }

    public HttpSeekableByteChannel(URL url, int blockSize, int maxCacheBlocks) throws IOException {
        this.url = url;
        this.blockSize = blockSize;
        this.cache = new LruCache(maxCacheBlocks);
        this.size = this.fetchRemoteSize(url);
        logger.info("Initialized HttpRangeSeekableByteChannel for URL: {} with blockSize: {} KB and cache capacity: {} blocks", new Object[]{url, blockSize / 1024, maxCacheBlocks});
    }

    public HttpSeekableByteChannel(URL url, int cacheSizeMB) throws IOException {
        this(url, 131072, cacheSizeMB * 1024 * 1024 / 131072);
    }

    private long fetchRemoteSize(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        connection.connect();
        long len = connection.getContentLengthLong();
        connection.disconnect();
        logger.debug("Fetched remote file size: {} bytes", (Object)len);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.lock.lock();
        try {
            int bytesRead = this.readImpl(dst, this.position);
            if (bytesRead > 0) {
                this.position += (long)bytesRead;
                this.totalBytesRead += (long)bytesRead;
            }
            logger.trace("Read {} bytes; updated position to {}", (Object)bytesRead, (Object)this.position);
            int n = bytesRead;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int readImpl(ByteBuffer dst, long readPosition) throws IOException {
        if (!this.open) {
            throw new IOException("Channel is closed");
        }
        if (readPosition >= this.size) {
            return -1;
        }
        int totalBytesReadLocal = 0;
        int bytesToRead = dst.remaining();
        while (bytesToRead > 0 && readPosition < this.size) {
            long blockIndex = readPosition / (long)this.blockSize;
            int blockOffset = (int)(readPosition % (long)this.blockSize);
            byte[] block = this.getOrFetchBlock(blockIndex);
            int bytesAvailable = Math.min(block.length - blockOffset, bytesToRead);
            dst.put(block, blockOffset, bytesAvailable);
            readPosition += (long)bytesAvailable;
            bytesToRead -= bytesAvailable;
            totalBytesReadLocal += bytesAvailable;
        }
        return totalBytesReadLocal;
    }

    private byte[] getOrFetchBlock(long blockIndex) throws IOException {
        try {
            int originalCacheHits = this.cacheHits++;
            return this.cache.computeIfAbsent(blockIndex, idx -> {
                try {
                    byte[] block = this.fetchBlockFromRemote((long)idx);
                    ++this.totalBlocksFetched;
                    ++this.cacheMisses;
                    this.cacheHits = originalCacheHits;
                    return block;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] fetchBlockFromRemote(long blockIndex) throws IOException {
        long start = blockIndex * (long)this.blockSize;
        long end = Math.min(this.size - 1L, start + (long)this.blockSize - 1L);
        IOException lastException = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            byte[] byArray;
            Throwable throwable;
            InputStream in;
            HttpURLConnection connection;
            block22: {
                block23: {
                    int totalRead;
                    int r;
                    connection = (HttpURLConnection)this.url.openConnection();
                    connection.setRequestProperty("Range", "bytes=" + start + "-" + end);
                    connection.connect();
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 206 && responseCode != 200) {
                        connection.disconnect();
                        throw new IOException("Unexpected response code " + responseCode + " for range " + start + "-" + end);
                    }
                    in = connection.getInputStream();
                    throwable = null;
                    int expectedSize = (int)(end - start + 1L);
                    byte[] buffer = new byte[expectedSize];
                    for (totalRead = 0; totalRead < expectedSize && (r = in.read(buffer, totalRead, expectedSize - totalRead)) != -1; totalRead += r) {
                    }
                    if (totalRead != expectedSize) {
                        throw new IOException("Incomplete read for block " + blockIndex + ": expected " + expectedSize + ", got " + totalRead);
                    }
                    logger.trace("Fetched block {} (bytes {}-{}) on attempt {}", new Object[]{blockIndex, start, end, attempt});
                    byArray = buffer;
                    if (in == null) break block22;
                    if (throwable == null) break block23;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                in.close();
            }
            connection.disconnect();
            return byArray;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (in != null) {
                                if (throwable != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        lastException = e;
                        logger.debug("Attempt {} for block {} failed: {}", new Object[]{attempt, blockIndex, e.getMessage()});
                        try {
                            Thread.sleep(100L * (long)attempt);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        connection.disconnect();
                        continue;
                    }
                }
                catch (Throwable throwable6) {
                    connection.disconnect();
                    throw throwable6;
                }
            }
        }
        throw new IOException("Failed to fetch block " + blockIndex + " after " + 3 + " attempts", lastException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.lock.lock();
        try {
            if (newPosition < 0L || newPosition > this.size) {
                throw new IllegalArgumentException("Invalid position: " + newPosition);
            }
            this.position = newPosition;
            HttpSeekableByteChannel httpSeekableByteChannel = this;
            return httpSeekableByteChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long position() {
        this.lock.lock();
        try {
            long l = this.position;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("truncate not supported");
    }

    @Override
    public int write(ByteBuffer src) {
        throw new UnsupportedOperationException("write not supported");
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.open = false;
            this.cache.clear();
            logger.info("HttpSeekableByteChannel closed. Total bytes read: {}. Blocks fetched: {}. Cache hits: {}. Cache misses: {}.", new Object[]{this.totalBytesRead, this.totalBlocksFetched, this.cacheHits, this.cacheMisses});
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class LruCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        public LruCache(int maxEntries) {
            super(maxEntries, 0.75f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxEntries;
        }
    }
}

