/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.storage;

import io.jhdf.Superblock;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfWritingException;
import io.jhdf.storage.HdfBackingStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class HdfFileChannel
implements HdfBackingStorage {
    private final FileChannel fc;
    private final Superblock sb;
    private boolean memoryMappingFailed;

    public HdfFileChannel(FileChannel fileChannel, Superblock superblock) {
        this.fc = fileChannel;
        this.sb = superblock;
    }

    @Override
    public ByteBuffer readBufferFromAddress(long address, int length) {
        long rawAddress = address + this.sb.getBaseAddressByte();
        try {
            return this.readBufferNoOffset(rawAddress, length);
        }
        catch (IOException e) {
            throw new HdfException("Failed to read from file at address '" + address + "' (raw address '" + rawAddress + "'", e);
        }
    }

    @Override
    public ByteBuffer map(long address, long length) {
        return this.mapNoOffset(address + this.sb.getBaseAddressByte(), length);
    }

    @Override
    public ByteBuffer mapNoOffset(long address, long length) {
        return this.mapNoOffset(address, length, FileChannel.MapMode.READ_ONLY);
    }

    public ByteBuffer mapNoOffset(long address, long length, FileChannel.MapMode mode) {
        try {
            if (!this.memoryMappingFailed) {
                try {
                    return this.fc.map(mode, address, length);
                }
                catch (IOException | UnsupportedOperationException e) {
                    this.memoryMappingFailed = true;
                }
            }
            return this.readBufferNoOffset(address, Math.toIntExact(length));
        }
        catch (IOException e) {
            throw new HdfException("Failed to map buffer at address '" + address + "' of length '" + length + "'", e);
        }
    }

    private ByteBuffer readBufferNoOffset(long address, int length) throws IOException {
        int numberOfBytesRead;
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int totalNumberOfBytesRead = 0; totalNumberOfBytesRead < length; totalNumberOfBytesRead += numberOfBytesRead) {
            numberOfBytesRead = this.fc.read(bb, address);
            if (numberOfBytesRead > 0) continue;
            throw new IOException("Trying to read more bytes than available");
        }
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.flip();
        return bb;
    }

    @Override
    public long getUserBlockSize() {
        return this.sb.getBaseAddressByte();
    }

    @Override
    public Superblock getSuperblock() {
        return this.sb;
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fc;
    }

    @Override
    public int getSizeOfOffsets() {
        return this.sb.getSizeOfOffsets();
    }

    @Override
    public int getSizeOfLengths() {
        return this.sb.getSizeOfLengths();
    }

    @Override
    public final void close() {
        try {
            this.fc.close();
        }
        catch (IOException e) {
            throw new HdfException("Failed closing HDF5 file", e);
        }
    }

    @Override
    public long size() {
        try {
            return this.fc.size();
        }
        catch (IOException e) {
            throw new HdfException("Failed to get size of HDF5 file", e);
        }
    }

    @Override
    public boolean inMemory() {
        return false;
    }

    public int write(ByteBuffer buffer, long position) {
        try {
            return this.fc.write(buffer, position);
        }
        catch (IOException e) {
            throw new HdfWritingException("Exception writing at position: " + position, e);
        }
    }

    public int write(ByteBuffer buffer) {
        try {
            return this.fc.write(buffer);
        }
        catch (IOException e) {
            throw new HdfWritingException("Exception writing", e);
        }
    }

    public void position(long dataAddress) {
        try {
            this.fc.position(dataAddress);
        }
        catch (IOException e) {
            throw new HdfWritingException("Exception writing", e);
        }
    }
}

