/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.nio.ByteBuffer;

public class SharedMessage {
    private final long objectHeaderAddress;

    public SharedMessage(ByteBuffer bb, Superblock sb) {
        byte version = bb.get();
        if (version < 1 || version > 3) {
            throw new HdfException("Unrecognized shared message version " + version);
        }
        byte type = bb.get();
        if (version == 1) {
            bb.position(bb.position() + 6);
        }
        if (version == 3 && type == 1) {
            throw new UnsupportedHdfException("Shared message v3 in fractal heap");
        }
        this.objectHeaderAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
    }

    public long getObjectHeaderAddress() {
        return this.objectHeaderAddress;
    }
}

