/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.AttributeInfoMessage;
import io.jhdf.object.message.AttributeMessage;
import io.jhdf.object.message.BTreeKValuesMessage;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.FillValueMessage;
import io.jhdf.object.message.FillValueOldMessage;
import io.jhdf.object.message.FilterPipelineMessage;
import io.jhdf.object.message.GroupInfoMessage;
import io.jhdf.object.message.LinkInfoMessage;
import io.jhdf.object.message.LinkMessage;
import io.jhdf.object.message.NilMessage;
import io.jhdf.object.message.ObjectCommentMessage;
import io.jhdf.object.message.ObjectHeaderContinuationMessage;
import io.jhdf.object.message.ObjectModificationTimeMessage;
import io.jhdf.object.message.ObjectReferenceCountMessage;
import io.jhdf.object.message.OldObjectModificationTimeMessage;
import io.jhdf.object.message.SymbolTableMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    private static final Logger logger = LoggerFactory.getLogger(Message.class);
    private static final int MESSAGE_DATA_CONSTANT = 0;
    private static final int MESSAGE_SHARED = 1;
    private static final int MESSAGE_SHOULD_NOT_BE_SHARED = 2;
    private static final int FAIL_ON_UNKNOWN_MESSAGE_TYPE_WITH_WRITE = 3;
    private static final int SET_FLAG_ON_MODIFICATION_WITH_UNKNOWN_MESSAGE = 4;
    private static final int OBJECT_MODIFIED_WITHOUT_UNDERSTANDING_MESSAGE = 5;
    private static final int MESSAGE_CAN_BE_SHARED = 6;
    private static final int ALWAYS_FAIL_ON_UNKNOWN_MESSAGE_TYPE = 7;
    public static final BitSet BASIC_FLAGS = new BitSet(1);
    private final BitSet flags;

    Message() {
        this.flags = BASIC_FLAGS;
    }

    Message(BitSet flags) {
        this.flags = flags;
    }

    public static Message readObjectHeaderV1Message(ByteBuffer bb, HdfBackingStorage hdfBackingStorage) {
        Utils.seekBufferToNextMultipleOfEight(bb);
        int messageType = Utils.readBytesAsUnsignedInt(bb, 2);
        int dataSize = Utils.readBytesAsUnsignedInt(bb, 2);
        BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
        bb.position(bb.position() + 3);
        ByteBuffer headerData = Utils.createSubBuffer(bb, dataSize);
        Message message = Message.readMessage(headerData, hdfBackingStorage, messageType, flags);
        logger.debug("Read message: {}", (Object)message);
        if (headerData.remaining() > 7) {
            logger.warn("After reading message ({}) buffer still has {} bytes remaining", (Object)message.getClass().getSimpleName(), (Object)headerData.remaining());
        }
        return message;
    }

    public static Message readObjectHeaderV2Message(ByteBuffer bb, HdfBackingStorage hdfBackingStorage, boolean attributeCreationOrderTracked) {
        int messageType = Utils.readBytesAsUnsignedInt(bb, 1);
        int dataSize = Utils.readBytesAsUnsignedInt(bb, 2);
        BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
        if (attributeCreationOrderTracked) {
            bb.getShort();
        }
        ByteBuffer headerData = Utils.createSubBuffer(bb, dataSize);
        Message message = Message.readMessage(headerData, hdfBackingStorage, messageType, flags);
        logger.debug("Read message: {}", (Object)message);
        if (headerData.hasRemaining()) {
            logger.warn("After reading message ({}) buffer still has {} bytes remaining", (Object)message.getClass().getSimpleName(), (Object)headerData.remaining());
        }
        return message;
    }

    private static Message readMessage(ByteBuffer bb, HdfBackingStorage hdfBackingStorage, int messageType, BitSet flags) {
        switch (messageType) {
            case 0: {
                return new NilMessage(bb, flags);
            }
            case 1: {
                return new DataSpaceMessage(bb, hdfBackingStorage.getSuperblock(), flags);
            }
            case 2: {
                return new LinkInfoMessage(bb, hdfBackingStorage.getSuperblock(), flags);
            }
            case 3: {
                return new DataTypeMessage(bb, flags);
            }
            case 4: {
                return new FillValueOldMessage(bb, flags);
            }
            case 5: {
                return new FillValueMessage(bb, flags);
            }
            case 6: {
                return new LinkMessage(bb, hdfBackingStorage.getSuperblock(), flags);
            }
            case 7: {
                throw new UnsupportedHdfException("Encountered External Data Files Message, this is not supported by jHDF");
            }
            case 8: {
                return DataLayoutMessage.createDataLayoutMessage(bb, hdfBackingStorage.getSuperblock(), flags);
            }
            case 9: {
                throw new HdfException("Encountered Bogus message. Is this a valid HDF5 file?");
            }
            case 10: {
                return new GroupInfoMessage(bb, flags);
            }
            case 11: {
                return new FilterPipelineMessage(bb, flags);
            }
            case 12: {
                return new AttributeMessage(bb, hdfBackingStorage, flags);
            }
            case 13: {
                return new ObjectCommentMessage(bb, flags);
            }
            case 14: {
                return new OldObjectModificationTimeMessage(bb, flags);
            }
            case 15: {
                throw new UnsupportedHdfException("Encountered Shared Message Table Message, this is not supported by jHDF");
            }
            case 16: {
                return new ObjectHeaderContinuationMessage(bb, hdfBackingStorage.getSuperblock(), flags);
            }
            case 17: {
                return new SymbolTableMessage(bb, hdfBackingStorage.getSuperblock(), flags);
            }
            case 18: {
                return new ObjectModificationTimeMessage(bb, flags);
            }
            case 19: {
                return new BTreeKValuesMessage(bb, flags);
            }
            case 20: {
                throw new UnsupportedHdfException("Encountered Driver Info Message, this is not supported by jHDF");
            }
            case 21: {
                return new AttributeInfoMessage(bb, hdfBackingStorage.getSuperblock(), flags);
            }
            case 22: {
                return new ObjectReferenceCountMessage(bb, flags);
            }
        }
        throw new HdfException("Unrecognized message type = " + messageType);
    }

    public abstract int getMessageType();

    public boolean isMessageDataConstant() {
        return this.flags.get(0);
    }

    public boolean isMessageShared() {
        return this.flags.get(1);
    }

    public boolean isMessageNotShared() {
        return this.flags.get(2);
    }

    public boolean isFailOnUnknownTypeWithWrite() {
        return this.flags.get(3);
    }

    public boolean isFlagToBeSetOnUnknownType() {
        return this.flags.get(4);
    }

    public boolean isObjectModifiedWithoutUnderstandingOfThisMessage() {
        return this.flags.get(5);
    }

    public boolean isMessageShareable() {
        return this.flags.get(6);
    }

    public boolean isAlwaysFailOnUnknownType() {
        return this.flags.get(7);
    }

    public byte[] flagsToBytes() {
        return Arrays.copyOf(this.flags.toByteArray(), 1);
    }

    public ByteBuffer toBuffer() {
        throw new UnsupportedHdfException("Writing of message [" + this.getClass().getSimpleName() + "] is not supported");
    }
}

