/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.BufferBuilder;
import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LinkMessage
extends Message {
    public static final int MESSAGE_TYPE = 6;
    private static final int CREATION_ORDER_PRESENT = 2;
    private static final int LINK_TYPE_PRESENT = 3;
    private static final int LINK_CHARACTER_SET_PRESENT = 4;
    private final byte version;
    private final BitSet flags;
    private final LinkType linkType;
    private final long creationOrder;
    private final Charset linkNameCharset;
    private final String linkName;
    private long hardLinkAddress;
    private String softLink;
    private String externalFile;
    private String externalPath;

    public static LinkMessage fromBuffer(ByteBuffer bb, Superblock sb) {
        return new LinkMessage(bb, sb, null);
    }

    LinkMessage(ByteBuffer bb, Superblock sb, BitSet messageFlags) {
        super(messageFlags);
        this.version = bb.get();
        if (this.version != 1) {
            throw new HdfException("Unrecognized version = " + this.version);
        }
        this.flags = BitSet.valueOf(new byte[]{bb.get()});
        int sizeOfLengthOfLinkName = this.getSizeOfLengthOfLinkName();
        this.linkType = this.flags.get(3) ? LinkType.fromValue(Utils.readBytesAsUnsignedInt(bb, 1)) : LinkType.HARD;
        this.creationOrder = this.flags.get(2) ? Utils.readBytesAsUnsignedLong(bb, 8) : -1L;
        if (this.flags.get(4)) {
            int charsetValue = Utils.readBytesAsUnsignedInt(bb, 1);
            switch (charsetValue) {
                case 0: {
                    this.linkNameCharset = StandardCharsets.US_ASCII;
                    break;
                }
                case 1: {
                    this.linkNameCharset = StandardCharsets.UTF_8;
                    break;
                }
                default: {
                    throw new HdfException("Unknown link charset value = " + charsetValue);
                }
            }
        } else {
            this.linkNameCharset = StandardCharsets.US_ASCII;
        }
        int lengthOfLinkName = Utils.readBytesAsUnsignedInt(bb, sizeOfLengthOfLinkName);
        ByteBuffer nameBuffer = Utils.createSubBuffer(bb, lengthOfLinkName);
        this.linkName = this.linkNameCharset.decode(nameBuffer).toString();
        switch (this.linkType) {
            case HARD: {
                this.hardLinkAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
                break;
            }
            case SOFT: {
                int lengthOfSoftLink = Utils.readBytesAsUnsignedInt(bb, 2);
                ByteBuffer linkBuffer = Utils.createSubBuffer(bb, lengthOfSoftLink);
                this.softLink = StandardCharsets.US_ASCII.decode(linkBuffer).toString();
                break;
            }
            case EXTERNAL: {
                int lengthOfExternalLink = Utils.readBytesAsUnsignedInt(bb, 2);
                ByteBuffer externalLinkBuffer = Utils.createSubBuffer(bb, lengthOfExternalLink);
                externalLinkBuffer.position(1);
                this.externalFile = Utils.readUntilNull(externalLinkBuffer);
                this.externalPath = Utils.readUntilNull(externalLinkBuffer);
                break;
            }
            default: {
                throw new HdfException("Unrecognized link type = " + (Object)((Object)this.linkType));
            }
        }
    }

    private LinkMessage(BitSet messageFlags, byte version, BitSet flags, LinkType linkType, long creationOrder, Charset linkNameCharset, String linkName, long hardLinkAddress) {
        super(messageFlags);
        this.version = version;
        this.flags = flags;
        this.linkType = linkType;
        this.creationOrder = creationOrder;
        this.linkNameCharset = linkNameCharset;
        this.linkName = linkName;
        this.hardLinkAddress = hardLinkAddress;
    }

    private int getSizeOfLengthOfLinkName() {
        int sizeOfLengthOfLinkName;
        int sizeOfLengthOfLinkNameIndex = Utils.bitsToInt(this.flags, 0, 2);
        switch (sizeOfLengthOfLinkNameIndex) {
            case 0: {
                sizeOfLengthOfLinkName = 1;
                break;
            }
            case 1: {
                sizeOfLengthOfLinkName = 2;
                break;
            }
            case 2: {
                sizeOfLengthOfLinkName = 4;
                break;
            }
            case 3: {
                sizeOfLengthOfLinkName = 8;
                break;
            }
            default: {
                throw new HdfException("Unrecognized size of link name");
            }
        }
        return sizeOfLengthOfLinkName;
    }

    public byte getVersion() {
        return this.version;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public long getCreationOrder() {
        return this.creationOrder;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public long getHardLinkAddress() {
        if (this.linkType == LinkType.HARD) {
            return this.hardLinkAddress;
        }
        throw new HdfException("This link message is not a hard link. Link type is: " + (Object)((Object)this.linkType));
    }

    public String getSoftLink() {
        if (this.linkType == LinkType.SOFT) {
            return this.softLink;
        }
        throw new HdfException("This link message is not a soft link. Link type is: " + (Object)((Object)this.linkType));
    }

    public String getExternalFile() {
        if (this.linkType == LinkType.EXTERNAL) {
            return this.externalFile;
        }
        throw new HdfException("This link message is not a external link. Link type is: " + (Object)((Object)this.linkType));
    }

    public String getExternalPath() {
        if (this.linkType == LinkType.EXTERNAL) {
            return this.externalPath;
        }
        throw new HdfException("This link message is not a external link. Link type is: " + (Object)((Object)this.linkType));
    }

    @Override
    public int getMessageType() {
        return 6;
    }

    @Override
    public ByteBuffer toBuffer() {
        BufferBuilder bufferBuilder = new BufferBuilder();
        bufferBuilder.writeByte(this.version);
        bufferBuilder.writeBitSet(this.flags, 1);
        if (this.flags.get(3)) {
            bufferBuilder.writeByte(this.linkType.getValue());
        }
        if (this.flags.get(2)) {
            bufferBuilder.writeLong(this.creationOrder);
        }
        if (this.flags.get(4) && this.linkNameCharset.equals(StandardCharsets.UTF_8)) {
            bufferBuilder.writeByte(1);
        }
        byte[] encodedLinkName = this.linkName.getBytes(this.linkNameCharset);
        bufferBuilder.writeShortestRepresentation(encodedLinkName.length);
        bufferBuilder.writeBytes(encodedLinkName);
        switch (this.linkType) {
            case HARD: {
                bufferBuilder.writeLong(this.hardLinkAddress);
                break;
            }
            case SOFT: {
                byte[] softLinkBytes = this.softLink.getBytes(StandardCharsets.US_ASCII);
                bufferBuilder.writeShort(softLinkBytes.length);
                bufferBuilder.writeBytes(softLinkBytes);
                break;
            }
            case EXTERNAL: {
                throw new UnsupportedHdfException("Writing External link not supported");
            }
        }
        return bufferBuilder.build();
    }

    public static LinkMessage create(String name, long address) {
        BitSet flags = new BitSet(1);
        flags.set(4);
        return new LinkMessage(new BitSet(1), 1, flags, LinkType.HARD, -1L, StandardCharsets.UTF_8, name, address);
    }

    public static enum LinkType {
        HARD(0),
        SOFT(1),
        EXTERNAL(64);

        private final int value;
        private static final Map<Integer, LinkType> LOOKUP_MAP;

        private LinkType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        private static LinkType fromValue(int value) {
            LinkType linkType = LOOKUP_MAP.get(value);
            if (linkType == null) {
                throw new HdfException("Unrecognized link type: " + value);
            }
            return linkType;
        }

        static {
            LOOKUP_MAP = Arrays.stream(LinkType.values()).collect(Collectors.toMap(LinkType::getValue, Function.identity()));
        }
    }
}

