/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.BufferBuilder;
import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class DataSpace {
    private static final int MAX_SIZES_PRESENT_BIT = 0;
    private final byte version;
    private final boolean maxSizesPresent;
    private final int[] dimensions;
    private final long[] maxSizes;
    private final byte type;

    private DataSpace(ByteBuffer bb, Superblock sb) {
        int i;
        this.version = bb.get();
        int numberOfDimensions = bb.get();
        byte[] flagBits = new byte[1];
        bb.get(flagBits);
        BitSet flags = BitSet.valueOf(flagBits);
        this.maxSizesPresent = flags.get(0);
        if (this.version == 1) {
            bb.position(bb.position() + 5);
            this.type = (byte)-1;
        } else if (this.version == 2) {
            this.type = bb.get();
        } else {
            throw new HdfException("Unrecognized version = " + this.version);
        }
        if (numberOfDimensions != 0) {
            this.dimensions = new int[numberOfDimensions];
            for (i = 0; i < numberOfDimensions; ++i) {
                this.dimensions[i] = Utils.readBytesAsUnsignedInt(bb, sb.getSizeOfLengths());
            }
        } else {
            this.dimensions = new int[0];
        }
        if (this.maxSizesPresent) {
            this.maxSizes = new long[numberOfDimensions];
            for (i = 0; i < numberOfDimensions; ++i) {
                this.maxSizes[i] = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfLengths());
            }
        } else {
            this.maxSizes = Arrays.stream(this.dimensions).asLongStream().toArray();
        }
    }

    private DataSpace(byte version, boolean maxSizesPresent, int[] dimensions, long[] maxSizes, byte type) {
        this.version = version;
        this.maxSizesPresent = maxSizesPresent;
        this.dimensions = dimensions;
        this.maxSizes = maxSizes;
        this.type = type;
    }

    public static DataSpace readDataSpace(ByteBuffer bb, Superblock sb) {
        return new DataSpace(bb, sb);
    }

    public static DataSpace fromObject(Object data) {
        if (data.getClass().isArray()) {
            int[] dimensions1 = Utils.getDimensions(data);
            return new DataSpace(2, false, dimensions1, Arrays.stream(dimensions1).asLongStream().toArray(), 1);
        }
        return new DataSpace(2, false, new int[0], new long[0], 0);
    }

    public long getTotalLength() {
        if (this.type == 2) {
            return 0L;
        }
        return IntStream.of(this.dimensions).mapToLong(Long::valueOf).reduce(1L, Math::multiplyExact);
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public int[] getDimensions() {
        return ArrayUtils.clone((int[])this.dimensions);
    }

    public long[] getMaxSizes() {
        return ArrayUtils.clone((long[])this.maxSizes);
    }

    public boolean isMaxSizesPresent() {
        return this.maxSizesPresent;
    }

    public ByteBuffer toBuffer() {
        BitSet flags = new BitSet(8);
        flags.set(0, this.maxSizesPresent);
        BufferBuilder bufferBuilder = new BufferBuilder().writeByte(this.version).writeByte(this.dimensions.length).writeBitSet(flags, 1).writeByte(this.type);
        for (int dimension : this.dimensions) {
            bufferBuilder.writeLong(dimension);
        }
        return bufferBuilder.build();
    }

    public DataSpace combineDim0(DataSpace ds2) {
        if (this.type != ds2.type) {
            throw new HdfException("Can't combine data spaces of different types");
        }
        if (this.dimensions.length != ds2.dimensions.length) {
            throw new HdfException("Can't combine data spaces of incongruent dimensional structure");
        }
        int[] dims = Arrays.copyOf(this.dimensions, this.dimensions.length);
        dims[0] = Math.addExact(this.dimensions[0], ds2.dimensions[0]);
        if (dims.length > 1) {
            for (int i = 1; i < dims.length; ++i) {
                if (this.dimensions[i] == ds2.dimensions[i]) continue;
                throw new HdfException("Can't combine data spaces of incongruent dimensionality at dimension " + i);
            }
        }
        long[] sizes = Arrays.copyOf(this.maxSizes, this.maxSizes.length);
        sizes[0] = Math.addExact(this.maxSizes[0], ds2.maxSizes[0]);
        return new DataSpace(this.version, this.maxSizesPresent, dims, sizes, this.type);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("DataSpace{");
        sb.append("dimensions=");
        if (this.dimensions == null) {
            sb.append("null");
        } else {
            sb.append('[');
            for (i = 0; i < this.dimensions.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.dimensions[i]);
            }
            sb.append(']');
        }
        sb.append(", version=").append(this.version);
        sb.append(", maxSizesPresent=").append(this.maxSizesPresent);
        sb.append(", maxSizes=");
        if (this.maxSizes == null) {
            sb.append("null");
        } else {
            sb.append('[');
            for (i = 0; i < this.maxSizes.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.maxSizes[i]);
            }
            sb.append(']');
        }
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public static DataSpace modifyDimensions(DataSpace ds, int[] dimensions) {
        int[] newdims = Arrays.copyOf(ds.dimensions, ds.getDimensions().length);
        System.arraycopy(dimensions, 0, newdims, 0, dimensions.length);
        long[] newsizes = Arrays.copyOf(ds.maxSizes, ds.maxSizes.length);
        for (int i = 0; i < dimensions.length; ++i) {
            newsizes[i] = dimensions[i];
        }
        return new DataSpace(ds.version, ds.maxSizesPresent, newdims, newsizes, ds.type);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof DataSpace)) {
            return false;
        }
        DataSpace dataSpace = (DataSpace)o;
        return this.version == dataSpace.version && this.maxSizesPresent == dataSpace.maxSizesPresent && this.type == dataSpace.type && Arrays.equals(this.dimensions, dataSpace.dimensions) && Arrays.equals(this.maxSizes, dataSpace.maxSizes);
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + Boolean.hashCode(this.maxSizesPresent);
        result = 31 * result + Arrays.hashCode(this.dimensions);
        result = 31 * result + Arrays.hashCode(this.maxSizes);
        result = 31 * result + this.type;
        return result;
    }
}

