/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.dataset.VariableLengthDatasetReader;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.StringData;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class VariableLength
extends DataType {
    private final int type;
    private final StringData.PaddingType paddingType;
    private final Charset encoding;
    private final DataType parent;

    public VariableLength(ByteBuffer bb) {
        super(bb);
        this.type = Utils.bitsToInt(this.classBits, 0, 4);
        int paddingTypeValue = Utils.bitsToInt(this.classBits, 4, 4);
        switch (paddingTypeValue) {
            case 0: {
                this.paddingType = StringData.PaddingType.NULL_TERMINATED;
                break;
            }
            case 1: {
                this.paddingType = StringData.PaddingType.NULL_PADDED;
                break;
            }
            case 2: {
                this.paddingType = StringData.PaddingType.SPACE_PADDED;
                break;
            }
            default: {
                throw new HdfException("Unrecognized padding type. Value is: " + paddingTypeValue);
            }
        }
        int characterEncoding = Utils.bitsToInt(this.classBits, 8, 4);
        switch (characterEncoding) {
            case 0: {
                this.encoding = StandardCharsets.US_ASCII;
                break;
            }
            case 1: {
                this.encoding = StandardCharsets.UTF_8;
                break;
            }
            default: {
                throw new HdfException("Unrecognized character encoding = " + characterEncoding);
            }
        }
        this.parent = DataType.readDataType(bb);
    }

    public boolean isVariableLengthString() {
        return this.type == 1;
    }

    public int getType() {
        return this.type;
    }

    public StringData.PaddingType getPaddingType() {
        if (!this.isVariableLengthString()) {
            throw new HdfException("Cannot get padding type for variable length dataset thats not string type");
        }
        return this.paddingType;
    }

    public Charset getEncoding() {
        if (!this.isVariableLengthString()) {
            throw new HdfException("Cannot get encoding for variable length dataset thats not string type");
        }
        return this.encoding;
    }

    public DataType getParent() {
        return this.parent;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.isVariableLengthString()) {
            return String.class;
        }
        return Object.class;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        return VariableLengthDatasetReader.readDataset(this, buffer, dimensions, hdfBackingStorage);
    }
}

