/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TimeDataType
extends DataType
implements OrderedDataType {
    public static final int CLASS_ID = 2;
    private final ByteOrder order;
    private final short bitPrecision;

    public TimeDataType(ByteBuffer bb) {
        super(bb);
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.bitPrecision = bb.getShort();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    @Override
    public Class<?> getJavaType() {
        return byte[].class;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        this.fillData(data, dimensions, buffer.order(this.getByteOrder()));
        return data;
    }

    private void fillData(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                this.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            for (int i = 0; i < Array.getLength(data); ++i) {
                byte[] bytes = new byte[this.getSize()];
                buffer.get(bytes);
                Array.set(data, i, bytes);
            }
        }
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }
}

