/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.BufferBuilder;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfWritingException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.storage.HdfBackingStorage;
import io.jhdf.storage.HdfFileChannel;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class StringData
extends DataType {
    public static final int CLASS_ID = 3;
    private final PaddingType paddingType;
    private final Charset charset;

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        StringData.fillFixedLengthStringData(data, dimensions, buffer, this.getSize(), this.getCharset(), this.getStringPaddingHandler());
        return data;
    }

    private static void fillFixedLengthStringData(Object data, int[] dims, ByteBuffer buffer, int stringLength, Charset charset, StringPaddingHandler stringPaddingHandler) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                StringData.fillFixedLengthStringData(newArray, Utils.stripLeadingIndex(dims), buffer, stringLength, charset, stringPaddingHandler);
            }
        } else {
            for (int i = 0; i < dims[0]; ++i) {
                ByteBuffer elementBuffer = Utils.createSubBuffer(buffer, stringLength);
                stringPaddingHandler.setBufferLimit(elementBuffer);
                Array.set(data, i, charset.decode(elementBuffer).toString());
            }
        }
    }

    public StringData(ByteBuffer bb) {
        super(bb);
        int paddingTypeValue = Utils.bitsToInt(this.classBits, 0, 4);
        switch (paddingTypeValue) {
            case 0: {
                this.paddingType = PaddingType.NULL_TERMINATED;
                break;
            }
            case 1: {
                this.paddingType = PaddingType.NULL_PADDED;
                break;
            }
            case 2: {
                this.paddingType = PaddingType.SPACE_PADDED;
                break;
            }
            default: {
                throw new HdfException("Unrecognized padding type. Value is: " + paddingTypeValue);
            }
        }
        int charsetIndex = Utils.bitsToInt(this.classBits, 4, 4);
        switch (charsetIndex) {
            case 0: {
                this.charset = StandardCharsets.US_ASCII;
                break;
            }
            case 1: {
                this.charset = StandardCharsets.UTF_8;
                break;
            }
            default: {
                throw new HdfException("Unrecognized Charset. Index is: " + charsetIndex);
            }
        }
    }

    public PaddingType getPaddingType() {
        return this.paddingType;
    }

    public StringPaddingHandler getStringPaddingHandler() {
        return this.paddingType.stringPaddingHandler;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    public static StringData create(Object data) {
        int maxLength = Arrays.stream(Utils.flatten(data)).map(String.class::cast).mapToInt(s -> StandardCharsets.UTF_8.encode((String)s).limit()).max().getAsInt();
        return new StringData(PaddingType.NULL_TERMINATED, StandardCharsets.UTF_8, maxLength);
    }

    private StringData(PaddingType paddingType, Charset charset, int maxLength) {
        super(3, maxLength + 1);
        this.paddingType = paddingType;
        this.charset = charset;
    }

    @Override
    public ByteBuffer toBuffer() {
        Utils.writeIntToBits(this.paddingType.id, this.classBits, 0, 4);
        Utils.writeIntToBits(1, this.classBits, 4, 4);
        return super.toBufferBuilder().build();
    }

    @Override
    public void writeData(Object data, int[] dimensions, HdfFileChannel hdfFileChannel) {
        if (data.getClass().isArray()) {
            int fastDimSize = dimensions[dimensions.length - 1];
            ByteBuffer buffer = ByteBuffer.allocate(fastDimSize * this.getSize());
            this.writeArrayData(data, dimensions, buffer, hdfFileChannel);
        } else {
            this.writeScalarData(data, hdfFileChannel);
        }
    }

    private void writeScalarData(Object data, HdfFileChannel hdfFileChannel) {
        ByteBuffer buffer = this.encodeScalarData(data);
        buffer.rewind();
        hdfFileChannel.write(buffer);
    }

    private void writeArrayData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                this.writeArrayData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel);
            }
        } else {
            String[] strings = (String[])data;
            for (int i = 0; i < strings.length; ++i) {
                String str = strings[i];
                buffer.put(this.charset.encode(str)).put((byte)0).position((i + 1) * this.getSize());
            }
            buffer.rewind();
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }

    private ByteBuffer encodeScalarData(Object data) {
        return new BufferBuilder().writeBuffer(this.charset.encode((String)data)).writeByte(0).build();
    }

    @Override
    public ByteBuffer encodeData(Object data) {
        Objects.requireNonNull(data, "Cannot encode null");
        if (data.getClass().isArray()) {
            int[] dimensions = Utils.getDimensions(data);
            int totalElements = Arrays.stream(dimensions).reduce(1, Math::multiplyExact);
            ByteBuffer buffer = ByteBuffer.allocate(totalElements * this.getSize());
            this.encodeDataInternal(data, dimensions, buffer);
            return buffer;
        }
        return this.encodeScalarData(data);
    }

    private void encodeDataInternal(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                this.encodeDataInternal(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            int offset = buffer.position();
            String[] strings = (String[])data;
            for (int i = 0; i < strings.length; ++i) {
                String str = strings[i];
                buffer.put(this.charset.encode(str)).put((byte)0).position(offset + (i + 1) * this.getSize());
            }
        }
    }

    public String toString() {
        return "StringData{paddingType=" + (Object)((Object)this.paddingType) + ", charset=" + this.charset + '}';
    }

    public StringData combine(StringData sd2) {
        StringData dt2 = sd2;
        if (this.getCharset() != dt2.getCharset()) {
            throw new HdfWritingException("Chunk data type does not match dataset data type");
        }
        if (this.getPaddingType() != dt2.getPaddingType()) {
            throw new HdfWritingException("Chunk data type does not match dataset data type");
        }
        return new StringData(this.paddingType, this.charset, Math.max(this.getSize(), dt2.getSize()));
    }

    static class SpacePadded
    implements StringPaddingHandler {
        SpacePadded() {
        }

        @Override
        public void setBufferLimit(ByteBuffer byteBuffer) {
            int i;
            for (i = byteBuffer.limit() - 1; i >= 0 && byteBuffer.get(i) == 32; --i) {
            }
            byteBuffer.limit(i + 1);
        }
    }

    static class NullPadded
    implements StringPaddingHandler {
        NullPadded() {
        }

        @Override
        public void setBufferLimit(ByteBuffer byteBuffer) {
            int i;
            for (i = byteBuffer.limit() - 1; i >= 0 && byteBuffer.get(i) == 0; --i) {
            }
            byteBuffer.limit(i + 1);
        }
    }

    static class NullTerminated
    implements StringPaddingHandler {
        NullTerminated() {
        }

        @Override
        public void setBufferLimit(ByteBuffer byteBuffer) {
            int i;
            int limit = byteBuffer.limit();
            for (i = 0; i < limit && byteBuffer.get(i) != 0; ++i) {
            }
            byteBuffer.limit(i);
        }
    }

    public static interface StringPaddingHandler {
        public void setBufferLimit(ByteBuffer var1);
    }

    public static enum PaddingType {
        NULL_TERMINATED(new NullTerminated(), 0),
        NULL_PADDED(new NullPadded(), 1),
        SPACE_PADDED(new SpacePadded(), 2);

        private final StringPaddingHandler stringPaddingHandler;
        private final int id;

        private PaddingType(StringPaddingHandler stringPaddingHandler, int id) {
            this.stringPaddingHandler = stringPaddingHandler;
            this.id = id;
        }
    }
}

