/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.BufferBuilder;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.ArrayDataType;
import io.jhdf.object.datatype.BitField;
import io.jhdf.object.datatype.CompoundDataType;
import io.jhdf.object.datatype.EnumDataType;
import io.jhdf.object.datatype.FixedPoint;
import io.jhdf.object.datatype.FloatingPoint;
import io.jhdf.object.datatype.OpaqueDataType;
import io.jhdf.object.datatype.Reference;
import io.jhdf.object.datatype.StringData;
import io.jhdf.object.datatype.TimeDataType;
import io.jhdf.object.datatype.VariableLength;
import io.jhdf.storage.HdfBackingStorage;
import io.jhdf.storage.HdfFileChannel;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataType {
    private static final Logger logger = LoggerFactory.getLogger(DataType.class);
    private final int version;
    private final int dataClass;
    private final int size;
    protected final BitSet classBits;

    protected DataType(int dataClass, int size) {
        this.version = 1;
        this.dataClass = dataClass;
        this.size = size;
        this.classBits = new BitSet(24);
    }

    public static DataType readDataType(ByteBuffer bb) {
        bb.mark();
        BitSet classAndVersion = BitSet.valueOf(new byte[]{bb.get()});
        int version = Utils.bitsToInt(classAndVersion, 4, 4);
        int dataClass = Utils.bitsToInt(classAndVersion, 0, 4);
        if (version == 0) {
            logger.warn("Datatype version 0 detected this is out of spec, attempting to read anyway");
        } else if (version > 3) {
            throw new HdfException("Unrecognized datatype version '" + version + "' detected");
        }
        bb.reset();
        switch (dataClass) {
            case 0: {
                return new FixedPoint(bb);
            }
            case 1: {
                return new FloatingPoint(bb);
            }
            case 2: {
                return new TimeDataType(bb);
            }
            case 3: {
                return new StringData(bb);
            }
            case 4: {
                return new BitField(bb);
            }
            case 5: {
                return new OpaqueDataType(bb);
            }
            case 6: {
                return new CompoundDataType(bb);
            }
            case 7: {
                return new Reference(bb);
            }
            case 8: {
                return new EnumDataType(bb);
            }
            case 9: {
                return new VariableLength(bb);
            }
            case 10: {
                return new ArrayDataType(bb);
            }
        }
        throw new HdfException("Unrecognized data class = " + dataClass);
    }

    protected DataType(ByteBuffer bb) {
        BitSet classAndVersion = BitSet.valueOf(new byte[]{bb.get()});
        this.dataClass = Utils.bitsToInt(classAndVersion, 0, 4);
        this.version = Utils.bitsToInt(classAndVersion, 4, 4);
        byte[] classBytes = new byte[3];
        bb.get(classBytes);
        this.classBits = BitSet.valueOf(classBytes);
        this.size = Utils.readBytesAsUnsignedInt(bb, 4);
    }

    public static DataType fromObject(Object data) {
        Class<?> type = Utils.getType(data);
        if (type == Byte.TYPE || type == Byte.class) {
            return new FixedPoint(1);
        }
        if (type == Short.TYPE || type == Short.class) {
            return new FixedPoint(2);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new FixedPoint(4);
        }
        if (type == Long.TYPE || type == Long.class) {
            return new FixedPoint(8);
        }
        if (type == Float.TYPE || type == Float.class) {
            return FloatingPoint.FLOAT;
        }
        if (type == Double.TYPE || type == Double.class) {
            return FloatingPoint.DOUBLE;
        }
        if (type == String.class) {
            return StringData.create(data);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return BitField.INSTANCE;
        }
        throw new HdfException("Could not create DataType for: " + type);
    }

    public int getVersion() {
        return this.version;
    }

    public int getDataClass() {
        return this.dataClass;
    }

    public int getSize() {
        return this.size;
    }

    public abstract Class<?> getJavaType();

    public abstract Object fillData(ByteBuffer var1, int[] var2, HdfBackingStorage var3);

    public ByteBuffer encodeData(Object data) {
        throw new UnsupportedHdfException("Data type [" + this.getClass().getSimpleName() + "] does not support writing");
    }

    public ByteBuffer toBuffer() {
        throw new UnsupportedHdfException("Data type [" + this.getClass().getSimpleName() + "] does not support writing");
    }

    protected BufferBuilder toBufferBuilder() {
        BitSet classAndVersion = new BitSet(8);
        Utils.writeIntToBits(this.dataClass, classAndVersion, 0, 4);
        Utils.writeIntToBits(this.version, classAndVersion, 4, 4);
        return new BufferBuilder().writeBitSet(classAndVersion, 1).writeBitSet(this.classBits, 3).writeInt(this.getSize());
    }

    public void writeData(Object data, int[] dimensions, HdfFileChannel hdfFileChannel) {
        throw new UnsupportedHdfException("Data type [" + this.getClass().getSimpleName() + "] does not support writing");
    }

    public DataType reduce(DataType dt2) {
        if (this instanceof StringData && dt2 instanceof StringData) {
            return ((StringData)this).combine((StringData)dt2);
        }
        if (this.getSize() != dt2.getSize()) {
            throw new HdfException("Can't reduce data types of different sizes");
        }
        if (this.getDataClass() != dt2.getDataClass()) {
            throw new HdfException("Can't reduced data types of different data classes");
        }
        return this;
    }
}

