/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.storage.HdfBackingStorage;
import io.jhdf.storage.HdfFileChannel;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class BitField
extends DataType
implements OrderedDataType {
    public static final int CLASS_ID = 4;
    private static final int ORDER_BIT = 0;
    private static final int LOW_PADDING_BIT = 1;
    private static final int HIGH_PADDING_BIT = 2;
    public static final BitField INSTANCE = new BitField();
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final short bitOffset;
    private final short bitPrecision;

    public BitField(ByteBuffer bb) {
        super(bb);
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.bitOffset = bb.getShort();
        this.bitPrecision = bb.getShort();
    }

    private BitField() {
        super(4, 1);
        this.order = ByteOrder.nativeOrder();
        this.bitPrecision = (short)8;
        this.bitOffset = 0;
        this.lowPadding = false;
        this.highPadding = false;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    @Override
    public Class<?> getJavaType() {
        return Boolean.TYPE;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        BitField.fillBitfieldData(data, dimensions, buffer.order(this.getByteOrder()));
        return data;
    }

    private static void fillBitfieldData(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                BitField.fillBitfieldData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            for (int i = 0; i < dims[0]; ++i) {
                Array.set(data, i, buffer.get() == 1);
            }
        }
    }

    @Override
    public ByteBuffer toBuffer() {
        this.classBits.set(0, this.order.equals(ByteOrder.BIG_ENDIAN));
        this.classBits.set(1, this.lowPadding);
        this.classBits.set(2, this.highPadding);
        return super.toBufferBuilder().writeShort(this.bitOffset).writeShort(this.bitPrecision).build();
    }

    @Override
    public ByteBuffer encodeData(Object data) {
        Objects.requireNonNull(data, "Cannot encode null");
        if (data.getClass().isArray()) {
            return this.encodeArrayData(data);
        }
        return this.encodeScalarData(data);
    }

    private ByteBuffer encodeScalarData(Object data) {
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize()).order(this.order);
        buffer.put(BitField.booleanToByte((Boolean)data));
        return buffer;
    }

    private ByteBuffer encodeArrayData(Object data) {
        Class<?> type = Utils.getType(data);
        int[] dimensions = Utils.getDimensions(data);
        int totalElements = Arrays.stream(dimensions).reduce(1, Math::multiplyExact);
        ByteBuffer buffer = ByteBuffer.allocate(totalElements * this.getSize()).order(this.order);
        if (type == Boolean.TYPE) {
            BitField.encodeBooleanData(data, dimensions, buffer, true);
        } else if (type == Boolean.class) {
            BitField.encodeBooleanData(data, dimensions, buffer, false);
        } else {
            throw new UnsupportedHdfException("Cant write type: " + type);
        }
        return buffer;
    }

    private static void encodeBooleanData(Object data, int[] dims, ByteBuffer buffer, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                BitField.encodeBooleanData(newArray, Utils.stripLeadingIndex(dims), buffer, primitive);
            }
        } else if (primitive) {
            buffer.put(BitField.asByteArray((boolean[])data));
        } else {
            buffer.put(BitField.asByteArray(ArrayUtils.toPrimitive((Boolean[])((Boolean[])data))));
        }
    }

    private static byte[] asByteArray(boolean[] data) {
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = BitField.booleanToByte(data[i]);
        }
        return bytes;
    }

    private static byte booleanToByte(boolean b) {
        return b ? (byte)1 : 0;
    }

    @Override
    public void writeData(Object data, int[] dimensions, HdfFileChannel hdfFileChannel) {
        if (data.getClass().isArray()) {
            this.writeArrayData(data, dimensions, hdfFileChannel);
        } else {
            this.writeScalarData(data, hdfFileChannel);
        }
    }

    private void writeScalarData(Object data, HdfFileChannel hdfFileChannel) {
        ByteBuffer buffer = this.encodeScalarData(data);
        buffer.rewind();
        hdfFileChannel.write(buffer);
    }

    private void writeArrayData(Object data, int[] dimensions, HdfFileChannel hdfFileChannel) {
        Class<?> type = Utils.getType(data);
        int fastDimSize = dimensions[dimensions.length - 1];
        ByteBuffer buffer = ByteBuffer.allocate(fastDimSize * this.getSize()).order(this.order);
        if (type == Boolean.TYPE) {
            BitField.writeBooleanData(data, dimensions, buffer, hdfFileChannel, true);
        } else if (type == Boolean.class) {
            BitField.writeBooleanData(data, dimensions, buffer, hdfFileChannel, false);
        } else {
            throw new UnsupportedHdfException("Cant write type: " + type);
        }
    }

    private static void writeBooleanData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                BitField.writeBooleanData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel, primitive);
            }
        } else {
            if (primitive) {
                buffer.put(BitField.asByteArray((boolean[])data));
            } else {
                buffer.put(BitField.asByteArray(ArrayUtils.toPrimitive((Boolean[])((Boolean[])data))));
            }
            buffer.rewind();
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }
}

