/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;

public class FileChannelFromSeekableByteChannel
extends FileChannel {
    private static final int MAX_TRANSFER_SIZE = 8192;
    private final SeekableByteChannel delegate;

    public FileChannelFromSeekableByteChannel(SeekableByteChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        this.checkAccess(position);
        long originalPosition = this.delegate.position();
        try {
            this.delegate.position(position);
            int n = this.delegate.read(dst);
            return n;
        }
        finally {
            this.delegate.position(originalPosition);
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int totalBytesRead = 0;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer dst = dsts[i];
            int bytesRead = this.read(dst);
            if (bytesRead == -1) {
                return totalBytesRead > 0 ? (long)totalBytesRead : -1L;
            }
            totalBytesRead += bytesRead;
            if (dst.hasRemaining()) break;
        }
        return totalBytesRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        this.checkAccess(position);
        long originalPosition = this.delegate.position();
        try {
            this.delegate.position(position);
            int n = this.delegate.write(src);
            return n;
        }
        finally {
            this.delegate.position(originalPosition);
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int totalBytesWritten = 0;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer src = srcs[i];
            int bytesWritten = this.write(src);
            totalBytesWritten += bytesWritten;
            if (src.hasRemaining()) break;
        }
        return totalBytesWritten;
    }

    @Override
    public long position() throws IOException {
        return this.delegate.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.delegate.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.delegate.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.delegate.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) {
        throw new UnsupportedOperationException("Cannot force updates to the underlying file");
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        this.checkTransfer(position, count, target);
        long size = this.size();
        if (count == 0L || position >= size) {
            return 0L;
        }
        if (position + count > size) {
            count = size - position;
        }
        return this.transferData(this.delegate, target, position, count);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.checkTransfer(position, count, src);
        long size = this.size();
        if (count == 0L || position > size) {
            return 0L;
        }
        return this.transferData(src, this.delegate, position, count);
    }

    private void checkTransfer(long position, long count, Channel other) throws ClosedChannelException {
        if (!other.isOpen()) {
            throw new ClosedChannelException();
        }
        this.checkAccess(position);
        if (count < 0L) {
            throw new IllegalArgumentException("Count must be non-negative");
        }
    }

    private void checkAccess(long position) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Position must be non-negative");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferData(ReadableByteChannel src, WritableByteChannel target, long delegateStartPosition, long count) throws IOException {
        long totalBytesTransferred;
        long originalPosition = this.delegate.position();
        try {
            int bytesWritten;
            int capacity = (int)Math.min(count, 8192L);
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            this.delegate.position(delegateStartPosition);
            for (totalBytesTransferred = 0L; totalBytesTransferred < count; totalBytesTransferred += (long)bytesWritten) {
                buffer.limit((int)Math.min(count - totalBytesTransferred, 8192L));
                int bytesRead = src.read(buffer);
                if (bytesRead <= 0) {
                    break;
                }
                buffer.flip();
                bytesWritten = target.write(buffer);
                if (bytesWritten != bytesRead) {
                    if (src != this.delegate) {
                        long readButUnwrittenBytes = bytesRead - bytesWritten;
                        if (src instanceof SeekableByteChannel) {
                            SeekableByteChannel srcChannel = (SeekableByteChannel)src;
                            srcChannel.position(srcChannel.position() - readButUnwrittenBytes);
                        } else {
                            while (bytesWritten < bytesRead) {
                                int missingBytesWritten = target.write(buffer);
                                if (missingBytesWritten == 0) {
                                    throw new IOException("Failed to write bytes to position " + this.delegate.position());
                                }
                                bytesWritten += missingBytesWritten;
                                totalBytesTransferred += (long)missingBytesWritten;
                            }
                        }
                    }
                    break;
                }
                buffer.clear();
            }
        }
        catch (IOException e) {
            if (totalBytesTransferred == 0L) {
                throw e;
            }
        }
        finally {
            this.delegate.position(originalPosition);
        }
        return totalBytesTransferred;
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.delegate.close();
    }
}

