/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.links;

import io.jhdf.HdfFile;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.exceptions.HdfBrokenLinkException;
import io.jhdf.links.AbstractLink;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class ExternalLink
extends AbstractLink {
    private final String targetFile;
    private final String targetPath;

    public ExternalLink(String targetFile, String targetPath, String name, Group parent) {
        super(name, parent);
        this.targetFile = targetFile;
        this.targetPath = targetPath;
        this.targetNode = new ExternalLinkTargetLazyInitializer();
    }

    @Override
    public Node getTarget() {
        try {
            return (Node)this.targetNode.get();
        }
        catch (Exception e) {
            throw new HdfBrokenLinkException("Could not resolve link target '" + this.targetPath + "' in external file '" + this.targetFile + "' from link '" + this.getPath() + "'", e);
        }
    }

    @Override
    public String getTargetPath() {
        return this.targetFile + ":" + this.targetPath;
    }

    public String toString() {
        return "ExternalLink [name=" + this.name + ", targetFile=" + this.targetFile + ", targetPath=" + this.targetPath + "]";
    }

    private class ExternalLinkTargetLazyInitializer
    extends LazyInitializer<Node> {
        private ExternalLinkTargetLazyInitializer() {
        }

        protected Node initialize() {
            HdfFile externalFile = new HdfFile(this.getTargetFile());
            ExternalLink.this.getHdfFile().addExternalFile(externalFile);
            return externalFile.getByPath(ExternalLink.this.targetPath);
        }

        private Path getTargetFile() {
            if (ExternalLink.this.targetFile.startsWith(File.separator)) {
                return Paths.get(ExternalLink.this.targetFile, new String[0]);
            }
            Path thisFilesDirectory = ExternalLink.this.parent.getFileAsPath().getParent();
            return thisFilesDirectory != null ? thisFilesDirectory.resolve(ExternalLink.this.targetFile) : null;
        }
    }
}

