/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.links;

import io.jhdf.HdfFile;
import io.jhdf.api.Attribute;
import io.jhdf.api.Group;
import io.jhdf.api.Link;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.exceptions.HdfException;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public abstract class AbstractLink
implements Link {
    protected final String name;
    protected final Group parent;
    protected LazyInitializer<Node> targetNode;

    public AbstractLink(String name, Group parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.parent.getPath() + this.name;
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.getTarget().getAttributes();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.getTarget().getAttribute(name);
    }

    @Override
    public NodeType getType() {
        return this.getTarget().getType();
    }

    @Override
    public boolean isGroup() {
        return this.getTarget().isGroup();
    }

    @Override
    public File getFile() {
        return this.parent.getFile();
    }

    @Override
    public Path getFileAsPath() {
        return this.parent.getFileAsPath();
    }

    @Override
    public HdfFile getHdfFile() {
        return this.parent.getHdfFile();
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public long getAddress() {
        return this.getTarget().getAddress();
    }

    @Override
    public boolean isBrokenLink() {
        try {
            this.getTarget();
            return false;
        }
        catch (HdfException e) {
            return true;
        }
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return this.getTarget().isAttributeCreationOrderTracked();
    }
}

