/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfFilterException;
import io.jhdf.filter.Filter;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class Lz4Filter
implements Filter {
    private final LazyInitializer<LZ4FastDecompressor> lzz4Decompressor = new LazyInitializer<LZ4FastDecompressor>(){

        protected LZ4FastDecompressor initialize() {
            return LZ4Factory.fastestJavaInstance().fastDecompressor();
        }
    };

    @Override
    public int getId() {
        return 32004;
    }

    @Override
    public String getName() {
        return "lz4";
    }

    @Override
    public byte[] decode(byte[] encodedData, int[] filterData) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encodedData);
        long totalDecompressedSize = Utils.readBytesAsUnsignedLong(byteBuffer, 8);
        byte[] decompressed = new byte[Math.toIntExact(totalDecompressedSize)];
        int decompressedBlockSize = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
        long blocks = (totalDecompressedSize + (long)decompressedBlockSize - 1L) / (long)decompressedBlockSize;
        int offset = 0;
        byte[] compressedBlock = new byte[]{};
        for (long i = 0L; i < blocks; ++i) {
            int compressedBlockSize = byteBuffer.getInt();
            if (compressedBlockSize > compressedBlock.length) {
                compressedBlock = new byte[compressedBlockSize];
            }
            byteBuffer.get(compressedBlock, 0, compressedBlockSize);
            int blockSize = Math.min(decompressed.length - offset, decompressedBlockSize);
            if (compressedBlockSize == blockSize) {
                System.arraycopy(compressedBlock, 0, decompressed, offset, blockSize);
            } else {
                try {
                    ((LZ4FastDecompressor)this.lzz4Decompressor.get()).decompress(compressedBlock, 0, decompressed, offset, blockSize);
                }
                catch (Exception e) {
                    throw new HdfFilterException("Failed LZ4 decompression", e);
                }
            }
            offset += blockSize;
        }
        return decompressed;
    }
}

