/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked.indexing;

import io.jhdf.Utils;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.DatasetInfo;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import io.jhdf.dataset.chunked.indexing.ChunkIndex;
import java.util.ArrayList;
import java.util.Collection;

public class ImplicitChunkIndex
implements ChunkIndex {
    private final int chunkSize;
    private final int[] datasetDimensions;
    private final int[] chunkDimensions;
    private final long baseAddress;

    public ImplicitChunkIndex(long baseAddress, DatasetInfo datasetInfo) {
        this.baseAddress = baseAddress;
        this.chunkSize = datasetInfo.getChunkSizeInBytes();
        this.datasetDimensions = datasetInfo.getDatasetDimensions();
        this.chunkDimensions = datasetInfo.getChunkDimensions();
    }

    @Override
    public Collection<Chunk> getAllChunks() {
        int totalChunks = Utils.totalChunks(this.datasetDimensions, this.chunkDimensions);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(totalChunks);
        for (int i = 0; i < totalChunks; ++i) {
            chunks.add(new ChunkImpl(this.baseAddress + (long)(i * this.chunkSize), this.chunkSize, Utils.chunkIndexToChunkOffset(i, this.chunkDimensions, this.datasetDimensions)));
        }
        return chunks;
    }
}

