/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked;

import io.jhdf.ObjectHeader;
import io.jhdf.Utils;
import io.jhdf.api.Group;
import io.jhdf.api.dataset.ChunkedDataset;
import io.jhdf.dataset.DatasetBase;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.ChunkOffset;
import io.jhdf.exceptions.HdfException;
import io.jhdf.filter.FilterManager;
import io.jhdf.filter.FilterPipeline;
import io.jhdf.filter.PipelineFilterWithData;
import io.jhdf.object.message.FilterPipelineMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkedDatasetBase
extends DatasetBase
implements ChunkedDataset {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedDatasetBase.class);
    protected final FilterPipelineLazyInitializer lazyPipeline = new FilterPipelineLazyInitializer();

    public ChunkedDatasetBase(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfBackingStorage, address, name, parent, oh);
    }

    protected void fillDataFromChunk(Chunk chunk, byte[] dataArray, int[] chunkDimensions, int[] chunkInternalOffsets, int[] dataOffsets, int fastestChunkDim, int elementSize) {
        logger.trace("Filling data from chunk '{}'", (Object)chunk);
        byte[] chunkData = this.decompressChunk(chunk);
        int[] chunkOffset = chunk.getChunkOffset();
        int initialChunkOffset = Utils.dimensionIndexToLinearIndex(chunkOffset, this.getDimensions());
        if (!this.isPartialChunk(chunk)) {
            int length = fastestChunkDim * elementSize;
            for (int i = 0; i < chunkInternalOffsets.length; ++i) {
                System.arraycopy(chunkData, chunkInternalOffsets[i], dataArray, (dataOffsets[i] + initialChunkOffset) * elementSize, length);
            }
        } else {
            logger.trace("Handling partial chunk '{}'", (Object)chunk);
            int highestDimIndex = this.getDimensions().length - 1;
            for (int i = 0; i < chunkInternalOffsets.length; ++i) {
                if (dataOffsets[i] > dataArray.length || this.partOfChunkIsOutsideDataset(chunkInternalOffsets[i] / elementSize, chunkDimensions, chunkOffset)) continue;
                int length = elementSize * Math.min(fastestChunkDim, fastestChunkDim - (chunkOffset[highestDimIndex] + chunkDimensions[highestDimIndex] - this.getDimensions()[highestDimIndex]));
                System.arraycopy(chunkData, chunkInternalOffsets[i], dataArray, (dataOffsets[i] + initialChunkOffset) * elementSize, length);
            }
        }
    }

    private boolean partOfChunkIsOutsideDataset(int chunkInternalOffsetIndex, int[] chunkDimensions, int[] chunkOffset) {
        int[] locationInChunk = Utils.linearIndexToDimensionIndex(chunkInternalOffsetIndex, chunkDimensions);
        for (int j = 0; j < locationInChunk.length - 1; ++j) {
            if (chunkOffset[j] + locationInChunk[j] < this.getDimensions()[j]) continue;
            return true;
        }
        return false;
    }

    protected int[] getDataOffsets(int[] chunkInternalOffsets) {
        int[] dimensionLinearOffsets = this.getDimensionLinearOffsets();
        int[] chunkDimensions = this.getChunkDimensions();
        int elementSize = this.getDataType().getSize();
        int[] dataOffsets = new int[chunkInternalOffsets.length];
        for (int i = 0; i < chunkInternalOffsets.length; ++i) {
            int[] chunkDimIndex = Utils.linearIndexToDimensionIndex(chunkInternalOffsets[i] / elementSize, chunkDimensions);
            int dataOffset = 0;
            for (int j = 0; j < chunkDimIndex.length; ++j) {
                dataOffset += chunkDimIndex[j] * dimensionLinearOffsets[j];
            }
            dataOffsets[i] = dataOffset;
        }
        return dataOffsets;
    }

    @Override
    public ByteBuffer getDataBuffer() {
        logger.trace("Getting data buffer for {}", (Object)this.getPath());
        byte[] dataArray = new byte[Math.toIntExact(this.getSizeInBytes())];
        logger.trace("Created data buffer for '{}' of size {} bytes", (Object)this.getPath(), (Object)dataArray.length);
        int elementSize = this.getDataType().getSize();
        Collection<Chunk> chunks = this.getAllChunks();
        int[] chunkDimensions = this.getChunkDimensions();
        int[] chunkInternalOffsets = this.getChunkInternalOffsets(chunkDimensions, elementSize);
        int[] dataOffsets = this.getDataOffsets(chunkInternalOffsets);
        int fastestChunkDim = chunkDimensions[chunkDimensions.length - 1];
        chunks.parallelStream().forEach(chunk -> this.fillDataFromChunk((Chunk)chunk, dataArray, chunkDimensions, chunkInternalOffsets, dataOffsets, fastestChunkDim, elementSize));
        return ByteBuffer.wrap(dataArray);
    }

    private int[] getDimensionLinearOffsets() {
        int dimLength = this.getDimensions().length;
        int[] dimensionLinearOffsets = new int[dimLength];
        Arrays.fill(dimensionLinearOffsets, 1);
        for (int i = 0; i < dimensionLinearOffsets.length - 1; ++i) {
            for (int j = i + 1; j < dimensionLinearOffsets.length; ++j) {
                int n = i;
                dimensionLinearOffsets[n] = dimensionLinearOffsets[n] * this.getDimensions()[j];
            }
        }
        return dimensionLinearOffsets;
    }

    protected int[] getChunkInternalOffsets(int[] chunkDimensions, int elementSize) {
        int fastestChunkDim = chunkDimensions[chunkDimensions.length - 1];
        int numOfOffsets = Arrays.stream(chunkDimensions).limit((long)chunkDimensions.length - 1L).reduce(1, Math::multiplyExact);
        int[] chunkOffsets = new int[numOfOffsets];
        for (int i = 0; i < numOfOffsets; ++i) {
            chunkOffsets[i] = i * fastestChunkDim * elementSize;
        }
        return chunkOffsets;
    }

    private boolean isPartialChunk(Chunk chunk) {
        int[] datasetDims = this.getDimensions();
        int[] chunkOffset = chunk.getChunkOffset();
        int[] chunkDims = this.getChunkDimensions();
        for (int i = 0; i < chunkOffset.length; ++i) {
            if (chunkOffset[i] + chunkDims[i] <= datasetDims[i]) continue;
            return true;
        }
        return false;
    }

    private byte[] decompressChunk(Chunk chunk) {
        ByteBuffer encodedBuffer = this.getDataBuffer(chunk);
        byte[] encodedBytes = new byte[encodedBuffer.remaining()];
        encodedBuffer.get(encodedBytes);
        try {
            FilterPipeline pipeline = (FilterPipeline)this.lazyPipeline.get();
            if (pipeline == FilterPipeline.NO_FILTERS) {
                return encodedBytes;
            }
            byte[] decodedBytes = pipeline.decode(encodedBytes);
            logger.trace("Decoded {}", (Object)chunk);
            return decodedBytes;
        }
        catch (ConcurrentException e) {
            throw new HdfException("Failed to get filter pipeline", e);
        }
    }

    private ByteBuffer getDataBuffer(Chunk chunk) {
        try {
            return this.hdfBackingStorage.map(chunk.getAddress(), chunk.getSize());
        }
        catch (Exception e) {
            throw new HdfException("Failed to read chunk for dataset '" + this.getPath() + "' at address " + chunk.getAddress());
        }
    }

    @Override
    public ByteBuffer getRawChunkBuffer(int[] chunkOffset) {
        Chunk chunk = this.getChunk(new ChunkOffset(chunkOffset));
        if (chunk == null) {
            throw new HdfException("No chunk with offset " + Arrays.toString(chunkOffset) + " in dataset: " + this.getPath());
        }
        return this.getDataBuffer(chunk);
    }

    @Override
    public byte[] getDecompressedChunk(int[] chunkOffset) {
        Chunk chunk = this.getChunk(new ChunkOffset(chunkOffset));
        if (chunk == null) {
            throw new HdfException("No chunk with offset " + Arrays.toString(chunkOffset) + " in dataset: " + this.getPath());
        }
        return this.decompressChunk(chunk);
    }

    private Collection<Chunk> getAllChunks() {
        return this.getChunkLookup().values();
    }

    private Chunk getChunk(ChunkOffset chunkOffset) {
        return this.getChunkLookup().get(chunkOffset);
    }

    protected abstract Map<ChunkOffset, Chunk> getChunkLookup();

    @Override
    public boolean isEmpty() {
        return this.getChunkLookup().isEmpty();
    }

    @Override
    public long getStorageInBytes() {
        return this.getChunkLookup().values().stream().mapToLong(Chunk::getSize).sum();
    }

    @Override
    public ByteBuffer getSliceDataBuffer(long[] sliceOffset, int[] sliceShape) {
        logger.trace("Getting slice data buffer for {} with shape {}", (Object)Arrays.toString(sliceOffset), (Object)Arrays.toString(sliceShape));
        int elementSize = this.getDataType().getSize();
        int sliceSize = Arrays.stream(sliceShape).reduce(1, Math::multiplyExact) * elementSize;
        byte[] dataArray = new byte[sliceSize];
        List<Chunk> overlappingChunks = this.findOverlappingChunks(sliceOffset, sliceShape);
        for (Chunk chunk : overlappingChunks) {
            this.copyChunkSliceToBuffer(chunk, sliceOffset, sliceShape, dataArray, elementSize);
        }
        return ByteBuffer.wrap(dataArray);
    }

    private List<Chunk> findOverlappingChunks(long[] offset, int[] shape) {
        int[] chunkDims = this.getChunkDimensions();
        ArrayList<Chunk> overlapping = new ArrayList<Chunk>();
        int[] startChunk = new int[offset.length];
        int[] endChunk = new int[offset.length];
        for (int i = 0; i < offset.length; ++i) {
            startChunk[i] = (int)(offset[i] / (long)chunkDims[i]);
            endChunk[i] = (int)((offset[i] + (long)shape[i] - 1L) / (long)chunkDims[i]);
        }
        for (int[] chunkCoords : this.getChunkCoordinateRange(startChunk, endChunk)) {
            Chunk chunk = this.getChunk(new ChunkOffset(chunkCoords));
            if (chunk == null) continue;
            overlapping.add(chunk);
        }
        return overlapping;
    }

    private List<int[]> getChunkCoordinateRange(int[] start, int[] end) {
        int dim;
        ArrayList<int[]> coords = new ArrayList<int[]>();
        int dims = start.length;
        int[] current = Arrays.copyOf(start, dims);
        block0: do {
            coords.add(Arrays.copyOf(current, dims));
            for (dim = dims - 1; dim >= 0; --dim) {
                int n = dim;
                current[n] = current[n] + 1;
                if (current[dim] <= end[dim]) continue block0;
                current[dim] = start[dim];
            }
        } while (dim >= 0);
        return coords;
    }

    private void copyChunkSliceToBuffer(Chunk chunk, long[] sliceOffset, int[] sliceShape, byte[] dataArray, int elementSize) {
        byte[] chunkData = this.decompressChunk(chunk);
        int[] chunkOffset = chunk.getChunkOffset();
        int[] chunkDims = this.getChunkDimensions();
        int[] fullDims = this.getDimensions();
        int rank = fullDims.length;
        int[] intersectStart = new int[rank];
        int[] intersectEnd = new int[rank];
        for (int i = 0; i < rank; ++i) {
            intersectStart[i] = Math.max((int)sliceOffset[i], chunkOffset[i]);
            intersectEnd[i] = Math.min((int)(sliceOffset[i] + (long)sliceShape[i]), chunkOffset[i] + chunkDims[i]);
        }
        int[] copyShape = new int[rank];
        int[] chunkStart = new int[rank];
        int[] sliceStart = new int[rank];
        for (int i = 0; i < rank; ++i) {
            copyShape[i] = intersectEnd[i] - intersectStart[i];
            chunkStart[i] = intersectStart[i] - chunkOffset[i];
            sliceStart[i] = intersectStart[i] - (int)sliceOffset[i];
        }
        int[] chunkStrides = this.getStrides(chunkDims);
        int[] sliceStrides = this.getStrides(sliceShape);
        int total = Arrays.stream(copyShape).reduce(1, Math::multiplyExact);
        int[] index = new int[rank];
        for (int n = 0; n < total; ++n) {
            int remainder = n;
            for (int d = rank - 1; d >= 0; --d) {
                index[d] = remainder % copyShape[d];
                remainder /= copyShape[d];
            }
            int chunkIdx = 0;
            int sliceIdx = 0;
            for (int d = 0; d < rank; ++d) {
                chunkIdx += (chunkStart[d] + index[d]) * chunkStrides[d];
                sliceIdx += (sliceStart[d] + index[d]) * sliceStrides[d];
            }
            System.arraycopy(chunkData, chunkIdx * elementSize, dataArray, sliceIdx * elementSize, elementSize);
        }
    }

    private int[] getStrides(int[] shape) {
        int rank = shape.length;
        int[] strides = new int[rank];
        strides[rank - 1] = 1;
        for (int i = rank - 2; i >= 0; --i) {
            strides[i] = strides[i + 1] * shape[i + 1];
        }
        return strides;
    }

    @Override
    public List<PipelineFilterWithData> getFilters() {
        try {
            return ((FilterPipeline)this.lazyPipeline.get()).getFilters();
        }
        catch (ConcurrentException e) {
            throw new HdfException("Failed to create filter pipeline", e);
        }
    }

    protected final class FilterPipelineLazyInitializer
    extends LazyInitializer<FilterPipeline> {
        protected FilterPipelineLazyInitializer() {
        }

        protected FilterPipeline initialize() {
            logger.debug("Lazy initializing filter pipeline for [{}]", (Object)ChunkedDatasetBase.this.getPath());
            if (ChunkedDatasetBase.this.oh.hasMessageOfType(FilterPipelineMessage.class)) {
                FilterPipelineMessage filterPipelineMessage = ChunkedDatasetBase.this.oh.getMessageOfType(FilterPipelineMessage.class);
                FilterPipeline filterPipeline = FilterManager.getPipeline(filterPipelineMessage);
                logger.info("Initialized filter pipeline [{}] for [{}]", (Object)filterPipeline, (Object)ChunkedDatasetBase.this.getPath());
                return filterPipeline;
            }
            logger.debug("No filters for [{}]", (Object)ChunkedDatasetBase.this.getPath());
            return FilterPipeline.NO_FILTERS;
        }
    }
}

