/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.GlobalHeap;
import io.jhdf.Utils;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.dataset.GlobalHeapId;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.VariableLength;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;

public final class VariableLengthDatasetReader {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    private VariableLengthDatasetReader() {
        throw new AssertionError((Object)"No instances of VariableLengthDatasetReader");
    }

    public static Object readDataset(VariableLength type, ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        boolean isScalar;
        Object data;
        Class<?> javaType = type.getJavaType();
        if (dimensions.length == 0) {
            data = Array.newInstance(javaType, 1);
            isScalar = true;
            dimensions = new int[]{1};
        } else {
            data = Array.newInstance(javaType, dimensions);
            isScalar = false;
        }
        HashMap<Long, GlobalHeap> heaps = new HashMap<Long, GlobalHeap>();
        ArrayList<ByteBuffer> elements = new ArrayList<ByteBuffer>();
        for (GlobalHeapId globalHeapId : VariableLengthDatasetReader.getGlobalHeapIds(buffer, type.getSize(), hdfBackingStorage, VariableLengthDatasetReader.getTotalPoints(dimensions))) {
            if (globalHeapId.getIndex() == 0) {
                elements.add(EMPTY_BYTE_BUFFER);
                continue;
            }
            GlobalHeap heap = heaps.computeIfAbsent(globalHeapId.getHeapAddress(), address -> new GlobalHeap(hdfBackingStorage, (long)address));
            ByteBuffer bb = heap.getObjectData(globalHeapId.getIndex());
            elements.add(bb);
        }
        if (type.isVariableLengthString()) {
            VariableLengthDatasetReader.fillStringData(type, data, dimensions, elements.iterator());
        } else {
            VariableLengthDatasetReader.fillData(type.getParent(), data, dimensions, elements.iterator(), hdfBackingStorage);
        }
        if (isScalar) {
            return Array.get(data, 0);
        }
        return data;
    }

    private static void fillData(DataType dataType, Object data, int[] dims, Iterator<ByteBuffer> elements, HdfBackingStorage hdfBackingStorage) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                VariableLengthDatasetReader.fillData(dataType, newArray, Utils.stripLeadingIndex(dims), elements, hdfBackingStorage);
            }
        } else {
            for (int i = 0; i < dims[0]; ++i) {
                ByteBuffer buffer = elements.next();
                int[] elementDims = new int[]{buffer.limit() / dataType.getSize()};
                Object elementData = DatasetReader.readDataset(dataType, buffer, elementDims, hdfBackingStorage);
                Array.set(data, i, elementData);
            }
        }
    }

    private static void fillStringData(VariableLength dataType, Object data, int[] dims, Iterator<ByteBuffer> elements) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                VariableLengthDatasetReader.fillStringData(dataType, newArray, Utils.stripLeadingIndex(dims), elements);
            }
        } else {
            for (int i = 0; i < dims[0]; ++i) {
                ByteBuffer buffer = elements.next();
                String element = dataType.getEncoding().decode(buffer).toString();
                Array.set(data, i, element);
            }
        }
    }

    private static List<GlobalHeapId> getGlobalHeapIds(ByteBuffer bb, int length, HdfBackingStorage hdfBackingStorage, int datasetTotalSize) {
        ArrayList<GlobalHeapId> ids = new ArrayList<GlobalHeapId>(datasetTotalSize);
        int skipBytes = length - hdfBackingStorage.getSizeOfOffsets() - 4;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        while (bb.remaining() >= length) {
            bb.position(bb.position() + skipBytes);
            long heapAddress = Utils.readBytesAsUnsignedLong(bb, hdfBackingStorage.getSizeOfOffsets());
            int index = Utils.readBytesAsUnsignedInt(bb, 4);
            GlobalHeapId globalHeapId = new GlobalHeapId(heapAddress, index);
            ids.add(globalHeapId);
        }
        return ids;
    }

    private static int getTotalPoints(int[] dimensions) {
        return IntStream.of(dimensions).reduce(1, Math::multiplyExact);
    }
}

