/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.ObjectHeader;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.dataset.CompactDataset;
import io.jhdf.dataset.ContiguousDatasetImpl;
import io.jhdf.dataset.chunked.ChunkedDatasetV3;
import io.jhdf.dataset.chunked.ChunkedDatasetV4;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.storage.HdfBackingStorage;

public final class DatasetLoader {
    private DatasetLoader() {
        throw new AssertionError((Object)"No instances of DatasetLoader");
    }

    public static Dataset createDataset(HdfBackingStorage hdfBackingStorage, ObjectHeader oh, String name, Group parent) {
        long address = oh.getAddress();
        try {
            DataLayoutMessage dlm = oh.getMessageOfType(DataLayoutMessage.class);
            if (dlm instanceof DataLayoutMessage.CompactDataLayoutMessage) {
                return new CompactDataset(hdfBackingStorage, address, name, parent, oh);
            }
            if (dlm instanceof DataLayoutMessage.ContiguousDataLayoutMessage) {
                return new ContiguousDatasetImpl(hdfBackingStorage, address, name, parent, oh);
            }
            if (dlm instanceof DataLayoutMessage.ChunkedDataLayoutMessage) {
                return new ChunkedDatasetV3(hdfBackingStorage, address, name, parent, oh);
            }
            if (dlm instanceof DataLayoutMessage.ChunkedDataLayoutMessageV4) {
                return new ChunkedDatasetV4(hdfBackingStorage, address, name, parent, oh);
            }
            throw new HdfException("Unrecognized Dataset layout type: " + dlm.getClass().getCanonicalName());
        }
        catch (Exception e) {
            throw new HdfException("Failed to read dataset '" + name + "' at address '" + address + "'", e);
        }
    }
}

