/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.AbstractNode;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.NodeType;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.InvalidSliceHdfException;
import io.jhdf.object.datatype.CompoundDataType;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.object.datatype.VariableLength;
import io.jhdf.object.message.DataLayout;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.object.message.DataSpace;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.FillValueMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatasetBase
extends AbstractNode
implements Dataset {
    private static final Logger logger = LoggerFactory.getLogger(DatasetBase.class);
    protected final HdfBackingStorage hdfBackingStorage;
    protected final ObjectHeader oh;
    private final DataType dataType;
    private final DataSpace dataSpace;

    protected DatasetBase(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfBackingStorage, address, name, parent);
        this.hdfBackingStorage = hdfBackingStorage;
        this.oh = oh;
        this.dataType = this.getHeaderMessage(DataTypeMessage.class).getDataType();
        this.dataSpace = this.getHeaderMessage(DataSpaceMessage.class).getDataSpace();
    }

    @Override
    public NodeType getType() {
        return NodeType.DATASET;
    }

    protected void convertToCorrectEndiness(ByteBuffer bb) {
        if (this.dataType instanceof OrderedDataType) {
            ByteOrder order = ((OrderedDataType)((Object)this.dataType)).getByteOrder();
            bb.order(order);
            if (logger.isTraceEnabled()) {
                logger.trace("Set buffer order of '{}' to {}", (Object)this.getPath(), (Object)order);
            }
        } else {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public long getSize() {
        return this.dataSpace.getTotalLength();
    }

    @Override
    public long getSizeInBytes() {
        return this.getSize() * (long)this.dataType.getSize();
    }

    @Override
    public int[] getDimensions() {
        return this.dataSpace.getDimensions();
    }

    @Override
    public long[] getMaxSize() {
        return this.dataSpace.getMaxSizes();
    }

    @Override
    public DataLayout getDataLayout() {
        return this.getHeaderMessage(DataLayoutMessage.class).getDataLayout();
    }

    @Override
    public Class<?> getJavaType() {
        Class<?> type = this.dataType.getJavaType();
        if (this.isScalar() && type.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(type);
        }
        return type;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Object getData() {
        logger.info("Getting data for '{}'...", (Object)this.getPath());
        if (this.isEmpty()) {
            return null;
        }
        StopWatch stopWatch = StopWatch.createStarted();
        ByteBuffer bb = this.getDataBuffer();
        DataType type = this.getDataType();
        Object data = DatasetReader.readDataset(type, bb, this.getDimensions(), this.hdfBackingStorage);
        stopWatch.stop();
        logger.info("Finished getting data for [{}] took [{}ms]", (Object)this.getPath(), (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
        return data;
    }

    @Override
    public Object getDataFlat() {
        logger.info("Getting flat data for [{}]...", (Object)this.getPath());
        if (this.isEmpty()) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        StopWatch stopWatch = StopWatch.createStarted();
        ByteBuffer bb = this.getDataBuffer();
        DataType type = this.getDataType();
        int elements = Math.toIntExact(this.getSize());
        Object data = DatasetReader.readDataset(type, bb, elements, this.hdfBackingStorage);
        stopWatch.stop();
        logger.info("Finished getting flat data for [{}] took [{}ms]", (Object)this.getPath(), (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
        return data;
    }

    @Override
    public Object getData(long[] sliceOffset, int[] sliceDimensions) {
        if (this.isEmpty()) {
            throw new HdfException("Cannot slice empty dataset");
        }
        if (this.isScalar()) {
            throw new HdfException("Cannot slice scalar dataset");
        }
        this.validateSliceRequest(sliceOffset, sliceDimensions);
        logger.debug("Getting data slice offset={} dimensions={} for [{}]'...", new Object[]{sliceOffset, sliceDimensions, this.getPath()});
        ByteBuffer sliceDataBuffer = this.getSliceDataBuffer(sliceOffset, sliceDimensions);
        return DatasetReader.readDataset(this.getDataType(), sliceDataBuffer, sliceDimensions, this.hdfBackingStorage);
    }

    private void validateSliceRequest(long[] sliceOffset, int[] sliceDimensions) {
        int numberOfDimensions = this.getDimensions().length;
        if (sliceOffset.length != numberOfDimensions || sliceDimensions.length != numberOfDimensions) {
            throw new InvalidSliceHdfException("Requested slice does not match dataset dimensions", sliceOffset, sliceDimensions, this.getDimensions());
        }
        for (int i = 0; i < sliceOffset.length; ++i) {
            if (sliceOffset[i] < 0L) {
                throw new InvalidSliceHdfException("Requested sliceOffset has negative value in dimension: " + i, sliceOffset, sliceDimensions, this.getDimensions());
            }
            if (sliceDimensions[i] <= 0) {
                throw new InvalidSliceHdfException("Requested sliceDimensions has negative or zero value in dimension: " + i, sliceOffset, sliceDimensions, this.getDimensions());
            }
            if (sliceOffset[i] + (long)sliceDimensions[i] <= (long)this.getDimensions()[i]) continue;
            throw new InvalidSliceHdfException("Requested slice exceeds dataset in dimension: " + i, sliceOffset, sliceDimensions, this.getDimensions());
        }
    }

    @Override
    public boolean isScalar() {
        return this.getDimensions().length == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getSizeInBytes() == 0L;
    }

    @Override
    public boolean isCompound() {
        return this.getDataType() instanceof CompoundDataType;
    }

    public abstract ByteBuffer getDataBuffer();

    public abstract ByteBuffer getSliceDataBuffer(long[] var1, int[] var2);

    @Override
    public Object getFillValue() {
        if (!this.getHeader().hasMessageOfType(FillValueMessage.class)) {
            return null;
        }
        FillValueMessage fillValueMessage = this.getHeaderMessage(FillValueMessage.class);
        if (fillValueMessage.isFillValueDefined()) {
            ByteBuffer bb = fillValueMessage.getFillValue();
            return DatasetReader.readDataset(this.getDataType(), bb, new int[0], this.hdfBackingStorage);
        }
        return null;
    }

    public String toString() {
        return "DatasetBase [path=" + this.getPath() + "]";
    }

    @Override
    public boolean isVariableLength() {
        return this.getDataType() instanceof VariableLength;
    }

    @Override
    public long getStorageInBytes() {
        return this.getSizeInBytes();
    }
}

