/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.checksum;

import java.nio.ByteBuffer;

public final class JenkinsLookup3HashLittle {
    private static final int INITIALISATION_CONSTANT = -559038737;

    private JenkinsLookup3HashLittle() {
        throw new AssertionError((Object)"No instances of JenkinsLookup3HashLittle");
    }

    public static int hash(byte[] key) {
        return JenkinsLookup3HashLittle.hash(key, 0);
    }

    public static int hash(ByteBuffer byteBuffer) {
        return JenkinsLookup3HashLittle.hash(byteBuffer, 0);
    }

    public static int hash(byte[] bytes, int initialValue) {
        return JenkinsLookup3HashLittle.hash(ByteBuffer.wrap(bytes), initialValue);
    }

    private static int finalMix(int a, int b, int c) {
        c ^= b;
        a ^= (c -= Integer.rotateLeft(b, 14));
        b ^= (a -= Integer.rotateLeft(c, 11));
        c ^= (b -= Integer.rotateLeft(a, 25));
        a ^= (c -= Integer.rotateLeft(b, 16));
        b ^= (a -= Integer.rotateLeft(c, 4));
        c ^= (b -= Integer.rotateLeft(a, 14));
        return c -= Integer.rotateLeft(b, 24);
    }

    public static int hash(ByteBuffer byteBuffer, int initialValue) {
        int a;
        int b;
        int c = b = (a = -559038737 + byteBuffer.remaining() + initialValue);
        while (byteBuffer.remaining() > 12) {
            a += Byte.toUnsignedInt(byteBuffer.get());
            a += Byte.toUnsignedInt(byteBuffer.get()) << 8;
            a += Byte.toUnsignedInt(byteBuffer.get()) << 16;
            a += Byte.toUnsignedInt(byteBuffer.get()) << 24;
            b += Byte.toUnsignedInt(byteBuffer.get());
            b += Byte.toUnsignedInt(byteBuffer.get()) << 8;
            b += Byte.toUnsignedInt(byteBuffer.get()) << 16;
            b += Byte.toUnsignedInt(byteBuffer.get()) << 24;
            c += Byte.toUnsignedInt(byteBuffer.get());
            c += Byte.toUnsignedInt(byteBuffer.get()) << 8;
            c += Byte.toUnsignedInt(byteBuffer.get()) << 16;
            a -= (c += Byte.toUnsignedInt(byteBuffer.get()) << 24);
            a ^= Integer.rotateLeft(c, 4);
            c += b;
            b -= a;
            b ^= Integer.rotateLeft(a, 6);
            a += c;
            c -= b;
            c ^= Integer.rotateLeft(b, 8);
            b += a;
            a -= c;
            a ^= Integer.rotateLeft(c, 16);
            c += b;
            b -= a;
            b ^= Integer.rotateLeft(a, 19);
            a += c;
            c -= b;
            c ^= Integer.rotateLeft(b, 4);
            b += a;
        }
        byte[] remainingBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(remainingBytes);
        switch (remainingBytes.length) {
            case 12: {
                c += Byte.toUnsignedInt(remainingBytes[11]) << 24;
            }
            case 11: {
                c += Byte.toUnsignedInt(remainingBytes[10]) << 16;
            }
            case 10: {
                c += Byte.toUnsignedInt(remainingBytes[9]) << 8;
            }
            case 9: {
                c += Byte.toUnsignedInt(remainingBytes[8]);
            }
            case 8: {
                b += Byte.toUnsignedInt(remainingBytes[7]) << 24;
            }
            case 7: {
                b += Byte.toUnsignedInt(remainingBytes[6]) << 16;
            }
            case 6: {
                b += Byte.toUnsignedInt(remainingBytes[5]) << 8;
            }
            case 5: {
                b += Byte.toUnsignedInt(remainingBytes[4]);
            }
            case 4: {
                a += Byte.toUnsignedInt(remainingBytes[3]) << 24;
            }
            case 3: {
                a += Byte.toUnsignedInt(remainingBytes[2]) << 16;
            }
            case 2: {
                a += Byte.toUnsignedInt(remainingBytes[1]) << 8;
            }
            case 1: {
                break;
            }
            case 0: {
                return c;
            }
            default: {
                throw new AssertionError((Object)"Invalid remaining bytes length");
            }
        }
        return JenkinsLookup3HashLittle.finalMix(a += Byte.toUnsignedInt(remainingBytes[0]), b, c);
    }
}

