/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.AbstractWritableNode;
import io.jhdf.ObjectHeader;
import io.jhdf.WritableDatasetImpl;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.api.WritableDataset;
import io.jhdf.api.WritableGroup;
import io.jhdf.api.WritableNode;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.AttributeInfoMessage;
import io.jhdf.object.message.AttributeMessage;
import io.jhdf.object.message.GroupInfoMessage;
import io.jhdf.object.message.LinkInfoMessage;
import io.jhdf.object.message.LinkMessage;
import io.jhdf.object.message.Message;
import io.jhdf.storage.HdfFileChannel;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableGroupImpl
extends AbstractWritableNode
implements WritableGroup {
    private static final Logger logger = LoggerFactory.getLogger(WritableGroupImpl.class);
    private final Map<String, WritableNode> children = new ConcurrentHashMap<String, WritableNode>();

    public WritableGroupImpl(Group parent, String name) {
        super(parent, name);
    }

    @Override
    public Map<String, Node> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    @Override
    public Node getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public Node getByPath(String path) {
        throw new UnsupportedHdfException("Not supported by writable groups");
    }

    @Override
    public Dataset getDatasetByPath(String path) {
        throw new UnsupportedHdfException("Not supported by writable groups");
    }

    @Override
    public boolean isLinkCreationOrderTracked() {
        return false;
    }

    @Override
    public NodeType getType() {
        return NodeType.GROUP;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public long getAddress() {
        return 0L;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return false;
    }

    @Override
    public WritableDataset putDataset(String name, Object data) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        WritableDataset writableDataset = null;
        if (data instanceof WritableDataset) {
            logger.debug("putting pre-initialized WritableDataset '" + name + "' into group '" + this.getName() + "'");
            writableDataset = (WritableDataset)data;
        } else {
            logger.debug("putting inferred dataset with type and shape inference '" + name + "' into group '" + this.getName() + "'");
            writableDataset = new WritableDatasetImpl(data, name, this);
        }
        this.children.put(name, writableDataset);
        logger.info("Added dataset [{}] to group [{}]", (Object)name, (Object)this.getPath());
        return writableDataset;
    }

    @Override
    public WritableGroup putGroup(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        WritableGroupImpl newGroup = new WritableGroupImpl(this, name);
        this.children.put(name, newGroup);
        logger.info("Added group [{}] to group [{}]", (Object)name, (Object)this.getPath());
        return newGroup;
    }

    @Override
    public Iterator<Node> iterator() {
        Collection<WritableNode> values = Collections.unmodifiableCollection(this.children.values());
        return values.iterator();
    }

    @Override
    public long write(HdfFileChannel hdfFileChannel, long position) {
        logger.info("Writing group [{}] at position [{}]", (Object)this.getPath(), (Object)position);
        ArrayList<Message> messages = new ArrayList<Message>();
        GroupInfoMessage groupInfoMessage = GroupInfoMessage.createBasic();
        messages.add(groupInfoMessage);
        LinkInfoMessage linkInfoMessage = LinkInfoMessage.createBasic();
        messages.add(linkInfoMessage);
        for (Map.Entry<String, WritableNode> entry : this.children.entrySet()) {
            LinkMessage linkMessage = LinkMessage.create(entry.getKey(), 0L);
            messages.add(linkMessage);
        }
        if (!this.getAttributes().isEmpty()) {
            AttributeInfoMessage attributeInfoMessage = AttributeInfoMessage.create();
            messages.add(attributeInfoMessage);
            for (Map.Entry<String, Attribute> entry : this.getAttributes().entrySet()) {
                logger.info("Writing attribute [{}] in group [{}]", (Object)entry.getKey(), (Object)this.getName());
                AttributeMessage attributeMessage = AttributeMessage.create(entry.getKey(), entry.getValue());
                messages.add(attributeMessage);
            }
        }
        ObjectHeader.ObjectHeaderV2 objectHeader = new ObjectHeader.ObjectHeaderV2(position, messages);
        ByteBuffer byteBuffer = objectHeader.toBuffer();
        int n = byteBuffer.limit();
        messages = new ArrayList();
        messages.add(groupInfoMessage);
        messages.add(linkInfoMessage);
        if (!this.getAttributes().isEmpty()) {
            AttributeInfoMessage attributeInfoMessage = AttributeInfoMessage.create();
            messages.add(attributeInfoMessage);
            for (Map.Entry<String, Attribute> attribute : this.getAttributes().entrySet()) {
                logger.info("Writing attribute [{}]", (Object)attribute.getKey());
                AttributeMessage attributeMessage = AttributeMessage.create(attribute.getKey(), attribute.getValue());
                messages.add(attributeMessage);
            }
        }
        long nextChildAddress = position + (long)n;
        for (Map.Entry<String, WritableNode> child : this.children.entrySet()) {
            long endPosition;
            LinkMessage linkMessage = LinkMessage.create(child.getKey(), nextChildAddress);
            messages.add(linkMessage);
            nextChildAddress = endPosition = child.getValue().write(hdfFileChannel, nextChildAddress);
        }
        objectHeader = new ObjectHeader.ObjectHeaderV2(position, messages);
        hdfFileChannel.write(objectHeader.toBuffer(), position);
        logger.info("Finished writing group [{}]", (Object)this.getPath());
        return nextChildAddress;
    }
}

