/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public final class Utils {
    private static final CharsetEncoder ASCII = StandardCharsets.US_ASCII.newEncoder();
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private Utils() {
        throw new AssertionError((Object)"No instances of Utils");
    }

    public static String toHex(long address) {
        if (address == -1L) {
            return "UNDEFINED";
        }
        return "0x" + Long.toHexString(address);
    }

    public static String readUntilNull(ByteBuffer buffer) {
        buffer.mark();
        int length = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 0) {
                buffer.reset();
                byte[] bytes = new byte[length];
                buffer.get(bytes);
                buffer.get();
                return new String(bytes, StandardCharsets.UTF_8);
            }
            ++length;
        }
        throw new IllegalArgumentException("End of buffer reached before NULL");
    }

    public static boolean validateName(String name) {
        return ASCII.canEncode(name) && !name.contains("/") && !name.contains(".");
    }

    public static void seekBufferToNextMultipleOfEight(ByteBuffer bb) {
        int pos = bb.position();
        if (pos % 8 == 0) {
            return;
        }
        bb.position(pos + (8 - pos % 8));
    }

    public static long nextMultipleOfEight(long value) {
        if (value % 8L == 0L) {
            return value;
        }
        return value + (8L - value % 8L);
    }

    public static int readBytesAsUnsignedInt(ByteBuffer buffer, int length) {
        switch (length) {
            case 1: {
                return Byte.toUnsignedInt(buffer.get());
            }
            case 2: {
                return Short.toUnsignedInt(buffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(buffer, length);
            }
            case 4: {
                int value = buffer.getInt();
                if (value < 0) {
                    throw new ArithmeticException("Could not convert to unsigned");
                }
                return value;
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(buffer, length);
            }
            case 8: {
                return Math.toIntExact(buffer.getLong());
            }
        }
        throw new IllegalArgumentException("Couldn't read " + length + " bytes as int");
    }

    private static int readArbitraryLengthBytesAsUnsignedInt(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new BigInteger(1, bytes).intValueExact();
    }

    public static long readBytesAsUnsignedLong(ByteBuffer buffer, int length) {
        switch (length) {
            case 1: {
                return Byte.toUnsignedLong(buffer.get());
            }
            case 2: {
                return Short.toUnsignedLong(buffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(buffer, length);
            }
            case 4: {
                return Integer.toUnsignedLong(buffer.getInt());
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(buffer, length);
            }
            case 8: {
                long value = buffer.getLong();
                if (value < 0L && value != -1L) {
                    throw new ArithmeticException("Could not convert to unsigned value: " + value);
                }
                return value;
            }
        }
        throw new IllegalArgumentException("Couldn't read " + length + " bytes as int");
    }

    private static long readArbitraryLengthBytesAsUnsignedLong(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new BigInteger(1, bytes).longValueExact();
    }

    public static ByteBuffer createSubBuffer(ByteBuffer source, int length) {
        ByteBuffer headerData = source.slice();
        headerData.limit(length);
        headerData.order(source.order());
        source.position(source.position() + length);
        return headerData;
    }

    public static int bitsToInt(BitSet bits, int start, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be >0");
        }
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < length; ++i) {
            if (!bits.get(start + i)) continue;
            result = result.add(TWO.pow(i));
        }
        return result.intValue();
    }

    public static int bytesNeededToHoldNumber(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("Only for unsigned numbers");
        }
        if (number == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)BigInteger.valueOf(number).bitLength() / 8.0);
    }

    public static int[] linearIndexToDimensionIndex(int index, int[] dimensions) {
        int[] dimIndex = new int[dimensions.length];
        for (int i = dimIndex.length - 1; i >= 0; --i) {
            dimIndex[i] = index % dimensions[i];
            index /= dimensions[i];
        }
        return dimIndex;
    }

    public static int dimensionIndexToLinearIndex(int[] index, int[] dimensions) {
        long[] indexAsLong = Arrays.stream(index).asLongStream().toArray();
        long linearLong = Utils.dimensionIndexToLinearIndex(indexAsLong, dimensions);
        return Math.toIntExact(linearLong);
    }

    public static long dimensionIndexToLinearIndex(long[] index, int[] dimensions) {
        if (index.length != dimensions.length) {
            throw new IllegalArgumentException("Mismatched index and dimension lengths");
        }
        for (int i = 0; i < dimensions.length; ++i) {
            if (index[i] < 0L || dimensions[i] < 0) {
                throw new IllegalArgumentException("Negative index or dimension values");
            }
            if (index[i] <= (long)dimensions[i]) continue;
            throw new IllegalArgumentException("index is greater than dimension size");
        }
        long linear = 0L;
        for (int i = 0; i < dimensions.length; ++i) {
            long temp = index[i];
            for (int j = i + 1; j < dimensions.length; ++j) {
                temp *= (long)dimensions[j];
            }
            linear += temp;
        }
        return linear;
    }

    public static int[] chunkIndexToChunkOffset(int chunkIndex, int[] chunkDimensions, int[] datasetDimensions) {
        int[] chunkOffset = new int[chunkDimensions.length];
        for (int i = 0; i < chunkOffset.length; ++i) {
            int chunksBelowThisDim = 1;
            for (int j = i + 1; j < chunkOffset.length; ++j) {
                chunksBelowThisDim *= (int)Math.ceil((double)datasetDimensions[j] / (double)chunkDimensions[j]);
            }
            chunkOffset[i] = chunkIndex / chunksBelowThisDim * chunkDimensions[i];
            chunkIndex -= chunkOffset[i] / chunkDimensions[i] * chunksBelowThisDim;
        }
        return chunkOffset;
    }

    public static int[] stripLeadingIndex(int[] dims) {
        return Arrays.copyOfRange(dims, 1, dims.length);
    }

    public static void setBit(byte[] bytes, int bit, boolean value) {
        if (bit < 0 || bit >= bytes.length * 8) {
            throw new IllegalArgumentException("bit index out of range. index=" + bit);
        }
        int byteIndex = bit / 8;
        int bitInByte = bit % 8;
        if (value) {
            int n = byteIndex;
            bytes[n] = (byte)(bytes[n] | (byte)(1 << bitInByte));
        } else {
            int n = byteIndex;
            bytes[n] = (byte)(bytes[n] & (byte)(~(1 << bitInByte)));
        }
    }

    public static boolean getBit(byte[] bytes, int bit) {
        int byteIndex = bit / 8;
        int bitInByte = bit % 8;
        return (bytes[byteIndex] >> bitInByte & 1) == 1;
    }

    public static int[] getDimensions(Object data) {
        ArrayList<Integer> dims = new ArrayList<Integer>();
        int dimLength = Array.getLength(data);
        dims.add(dimLength);
        while (dimLength > 0 && Array.get(data, 0).getClass().isArray()) {
            data = Array.get(data, 0);
            dims.add(Array.getLength(data));
        }
        return ArrayUtils.toPrimitive((Integer[])dims.toArray(new Integer[0]));
    }

    public static Class<?> getType(Object obj) {
        Class<?> type = obj.getClass().isArray() ? Utils.getArrayType(obj) : obj.getClass();
        return type;
    }

    public static Class<?> getArrayType(Object array) {
        Object element = Array.get(array, 0);
        if (element.getClass().isArray()) {
            return Utils.getArrayType(element);
        }
        return array.getClass().getComponentType();
    }

    public static void writeIntToBits(int value, BitSet bits, int start, int length) {
        if (value < 0) {
            throw new IllegalArgumentException("Value cannot be negative");
        }
        BigInteger bi = BigInteger.valueOf(value);
        if (bi.bitLength() > length) {
            throw new IllegalArgumentException("Value [" + value + "] to high to convert to bits");
        }
        for (int i = 0; i < length; ++i) {
            bits.set(start + i, bi.testBit(i));
        }
    }

    public static Object[] flatten(Object data) {
        ArrayList<Object> flat = new ArrayList<Object>();
        Utils.flattenInternal(data, flat);
        return flat.toArray();
    }

    private static void flattenInternal(Object data, List<Object> flat) {
        if (data.getClass().isArray()) {
            int length = Array.getLength(data);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(data, i);
                if (element.getClass().isArray()) {
                    Utils.flattenInternal(element, flat);
                    continue;
                }
                flat.add(element);
            }
        } else {
            flat.add(data);
        }
    }

    public static int totalChunks(int[] datasetDimensions, int[] chunkDimensions) {
        int chunks = 1;
        for (int i = 0; i < datasetDimensions.length; ++i) {
            int chunksInDim = datasetDimensions[i] / chunkDimensions[i];
            if (datasetDimensions[i] % chunkDimensions[i] != 0) {
                ++chunksInDim;
            }
            chunks *= chunksInDim;
        }
        return chunks;
    }
}

