/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFile;
import io.jhdf.exceptions.HdfException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TempHdfFile
extends HdfFile {
    private static final Logger logger = LoggerFactory.getLogger(TempHdfFile.class);

    private TempHdfFile(Path tempFile) {
        super(tempFile);
    }

    @Override
    public void close() {
        super.close();
        logger.info("Deleting temp file on close [{}]", (Object)this.getFileAsPath().toAbsolutePath());
        boolean deleteSuccess = this.getFile().delete();
        if (!deleteSuccess) {
            logger.warn("Could not delete temp file [{}]", (Object)this.getFileAsPath().toAbsolutePath());
        }
    }

    public static TempHdfFile fromInputStream(InputStream inputStream) {
        try {
            Path tempFile = Files.createTempFile(null, "-stream.hdf5", new FileAttribute[0]);
            logger.info("Creating temp file [{}]", (Object)tempFile.toAbsolutePath());
            tempFile.toFile().deleteOnExit();
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            logger.debug("Read stream to temp file [{}]", (Object)tempFile.toAbsolutePath());
            return new TempHdfFile(tempFile);
        }
        catch (IOException e) {
            throw new HdfException("Failed to open input stream", e);
        }
    }
}

