/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.AttributeImpl;
import io.jhdf.FractalHeap;
import io.jhdf.HdfFile;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Attribute;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.btree.BTreeV2;
import io.jhdf.btree.record.AttributeNameForIndexedAttributesRecord;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.AttributeInfoMessage;
import io.jhdf.object.message.AttributeMessage;
import io.jhdf.object.message.Message;
import io.jhdf.storage.HdfBackingStorage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNode
implements Node {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNode.class);
    private final HdfBackingStorage hdfBackingStorage;
    protected final long address;
    protected final String name;
    protected final Group parent;
    protected final LazyInitializer<ObjectHeader> header;
    protected final AttributesLazyInitializer attributes;

    protected AbstractNode(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent) {
        this.hdfBackingStorage = hdfBackingStorage;
        this.address = address;
        this.name = name;
        this.parent = parent;
        try {
            this.header = ObjectHeader.lazyReadObjectHeader(hdfBackingStorage, address);
            this.attributes = new AttributesLazyInitializer(this.header);
        }
        catch (Exception e) {
            throw new HdfException("Error reading node '" + this.getPath() + "' at address " + address, e);
        }
    }

    @Override
    public boolean isGroup() {
        return this.getType() == NodeType.GROUP;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.parent.getPath() + this.name;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public Path getFileAsPath() {
        return this.getParent().getFileAsPath();
    }

    @Override
    public HdfFile getHdfFile() {
        return this.getParent().getHdfFile();
    }

    @Override
    public boolean isLink() {
        return false;
    }

    protected <T extends Message> T getHeaderMessage(Class<T> clazz) {
        return this.getHeader().getMessageOfType(clazz);
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        try {
            return (Map)this.attributes.get();
        }
        catch (Exception e) {
            throw new HdfException("Failed to load attributes for '" + this.getPath() + "' at address '" + this.getAddress() + "'", e);
        }
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return this.getHeader().isAttributeCreationOrderTracked();
    }

    public ObjectHeader getHeader() {
        try {
            return (ObjectHeader)this.header.get();
        }
        catch (Exception e) {
            throw new HdfException("Failed reading header for '" + this.getPath() + "' at address '" + this.getAddress() + "'", e);
        }
    }

    protected final class AttributesLazyInitializer
    extends LazyInitializer<Map<String, Attribute>> {
        private final LazyInitializer<ObjectHeader> lazyObjectHeader;

        public AttributesLazyInitializer(LazyInitializer<ObjectHeader> lazyObjectHeader) {
            this.lazyObjectHeader = lazyObjectHeader;
        }

        protected Map<String, Attribute> initialize() throws ConcurrentException {
            AttributeInfoMessage attributeInfoMessage;
            logger.debug("Lazy initializing attributes for '{}'", (Object)AbstractNode.this.getPath());
            ObjectHeader oh = (ObjectHeader)this.lazyObjectHeader.get();
            ArrayList<AttributeMessage> attributeMessages = new ArrayList<AttributeMessage>();
            if (oh.hasMessageOfType(AttributeInfoMessage.class) && (attributeInfoMessage = oh.getMessageOfType(AttributeInfoMessage.class)).getFractalHeapAddress() != -1L) {
                FractalHeap fractalHeap = new FractalHeap(AbstractNode.this.hdfBackingStorage, attributeInfoMessage.getFractalHeapAddress());
                BTreeV2 btree = new BTreeV2(AbstractNode.this.hdfBackingStorage, attributeInfoMessage.getAttributeNameBTreeAddress());
                for (AttributeNameForIndexedAttributesRecord attributeRecord : btree.getRecords()) {
                    ByteBuffer bb = fractalHeap.getId(attributeRecord.getHeapId());
                    AttributeMessage attributeMessage = new AttributeMessage(bb, AbstractNode.this.hdfBackingStorage, attributeRecord.getFlags());
                    logger.trace("Read attribute message '{}'", (Object)attributeMessage);
                    attributeMessages.add(attributeMessage);
                }
            }
            attributeMessages.addAll(oh.getMessagesOfType(AttributeMessage.class));
            return attributeMessages.stream().collect(Collectors.toMap(AttributeMessage::getName, message -> new AttributeImpl(AbstractNode.this.hdfBackingStorage, AbstractNode.this, (AttributeMessage)message)));
        }
    }
}

