/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.DataLayout;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public abstract class DataLayoutMessage
extends Message {
    public DataLayoutMessage(BitSet flags) {
        super(flags);
    }

    public abstract DataLayout getDataLayout();

    public static DataLayoutMessage createDataLayoutMessage(ByteBuffer bb, Superblock sb, BitSet flags) {
        byte version = bb.get();
        if (version != 3 && version != 4) {
            throw new UnsupportedHdfException("Only v3 and v4 data layout messages are supported. Detected version = " + version);
        }
        byte layoutClass = bb.get();
        switch (layoutClass) {
            case 0: {
                return new CompactDataLayoutMessage(bb, flags);
            }
            case 1: {
                return new ContiguousDataLayoutMessage(bb, sb, flags);
            }
            case 2: {
                if (version == 3) {
                    return new ChunkedDataLayoutMessageV3(bb, sb, flags);
                }
                return new ChunkedDataLayoutMessageV4(bb, sb, flags);
            }
            case 3: {
                throw new UnsupportedHdfException("Virtual storage is not supported");
            }
        }
        throw new UnsupportedHdfException("Unknown storage layout " + layoutClass);
    }

    public static class ChunkedDataLayoutMessageV4
    extends DataLayoutMessage {
        private static final int DONT_FILTER_PARTIAL_BOUND_CHUNKS = 0;
        private static final int SINGLE_INDEX_WITH_FILTER = 1;
        private final long address;
        private final byte indexingType;
        private final int[] chunkDimensions;
        private byte pageBits;
        private byte maxBits;
        private byte indexElements;
        private byte minPointers;
        private byte minElements;
        private int nodeSize;
        private byte splitPercent;
        private byte mergePercent;
        private boolean isFilteredSingleChunk = false;
        private int sizeOfFilteredSingleChunk;
        private BitSet filterMaskFilteredSingleChunk;

        private ChunkedDataLayoutMessageV4(ByteBuffer bb, Superblock sb, BitSet flags) {
            super(flags);
            BitSet chunkedFlags = BitSet.valueOf(new byte[]{bb.get()});
            byte chunkDimensionality = bb.get();
            byte dimSizeBytes = bb.get();
            this.chunkDimensions = new int[chunkDimensionality];
            for (int i = 0; i < this.chunkDimensions.length; ++i) {
                this.chunkDimensions[i] = Utils.readBytesAsUnsignedInt(bb, dimSizeBytes);
            }
            this.indexingType = bb.get();
            switch (this.indexingType) {
                case 1: {
                    if (!chunkedFlags.get(1)) break;
                    this.isFilteredSingleChunk = true;
                    this.sizeOfFilteredSingleChunk = Utils.readBytesAsUnsignedInt(bb, sb.getSizeOfLengths());
                    this.filterMaskFilteredSingleChunk = BitSet.valueOf(new byte[]{bb.get(), bb.get(), bb.get(), bb.get()});
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.pageBits = bb.get();
                    break;
                }
                case 4: {
                    this.maxBits = bb.get();
                    this.indexElements = bb.get();
                    this.minPointers = bb.get();
                    this.minElements = bb.get();
                    this.pageBits = bb.get();
                    break;
                }
                case 5: {
                    this.nodeSize = bb.getInt();
                    this.splitPercent = bb.get();
                    this.mergePercent = bb.get();
                    break;
                }
                default: {
                    throw new UnsupportedHdfException("Unrecognized chunk indexing type. type=" + this.indexingType);
                }
            }
            this.address = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.CHUNKED;
        }

        public long getAddress() {
            return this.address;
        }

        public byte getPageBits() {
            return this.pageBits;
        }

        public byte getMaxBits() {
            return this.maxBits;
        }

        public byte getIndexElements() {
            return this.indexElements;
        }

        public byte getMinPointers() {
            return this.minPointers;
        }

        public byte getMinElements() {
            return this.minElements;
        }

        public int getNodeSize() {
            return this.nodeSize;
        }

        public byte getSplitPercent() {
            return this.splitPercent;
        }

        public byte getMergePercent() {
            return this.mergePercent;
        }

        public byte getIndexingType() {
            return this.indexingType;
        }

        public int[] getChunkDimensions() {
            return ArrayUtils.clone((int[])this.chunkDimensions);
        }

        public int getSizeOfFilteredSingleChunk() {
            if (!this.isFilteredSingleChunk) {
                throw new HdfException("Requested size of filtered single chunk when its not set.");
            }
            return this.sizeOfFilteredSingleChunk;
        }

        public BitSet getFilterMaskFilteredSingleChunk() {
            if (!this.isFilteredSingleChunk) {
                throw new HdfException("Requested filter mask of filtered single chunk when its not set.");
            }
            return this.filterMaskFilteredSingleChunk;
        }

        public boolean isFilteredSingleChunk() {
            return this.isFilteredSingleChunk;
        }
    }

    public static class ChunkedDataLayoutMessageV3
    extends DataLayoutMessage {
        private final long address;
        private final int size;
        private final int[] chunkDimensions;

        private ChunkedDataLayoutMessageV3(ByteBuffer bb, Superblock sb, BitSet flags) {
            super(flags);
            int chunkDimensionality = bb.get() - 1;
            this.address = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
            this.chunkDimensions = new int[chunkDimensionality];
            for (int i = 0; i < this.chunkDimensions.length; ++i) {
                this.chunkDimensions[i] = Utils.readBytesAsUnsignedInt(bb, 4);
            }
            this.size = Utils.readBytesAsUnsignedInt(bb, 4);
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.CHUNKED;
        }

        public long getBTreeAddress() {
            return this.address;
        }

        public int getSize() {
            return this.size;
        }

        public int[] getChunkDimensions() {
            return ArrayUtils.clone((int[])this.chunkDimensions);
        }
    }

    public static class ContiguousDataLayoutMessage
    extends DataLayoutMessage {
        private final long address;
        private final long size;

        private ContiguousDataLayoutMessage(ByteBuffer bb, Superblock sb, BitSet flags) {
            super(flags);
            this.address = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
            this.size = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfLengths());
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.CONTIGUOUS;
        }

        public long getAddress() {
            return this.address;
        }

        public long getSize() {
            return this.size;
        }
    }

    public static class CompactDataLayoutMessage
    extends DataLayoutMessage {
        private final ByteBuffer dataBuffer;

        private CompactDataLayoutMessage(ByteBuffer bb, BitSet flags) {
            super(flags);
            int compactDataSize = Utils.readBytesAsUnsignedInt(bb, 2);
            this.dataBuffer = Utils.createSubBuffer(bb, compactDataSize);
        }

        @Override
        public DataLayout getDataLayout() {
            return DataLayout.COMPACT;
        }

        public ByteBuffer getDataBuffer() {
            return this.dataBuffer;
        }
    }
}

